from sandbox import sdk2
from sandbox.projects.maps.mobile.utils.subtask_runner import SubtaskRunner
from sandbox.projects.maps.mobile.MapsMobileExportArtifactsBase \
        import MapsMobileExportArtifactsBase


# Remove this const and its uses when support for all such old branches is dropped.
_LAST_BRANCH_WITHOUT_PROTOC = '20200612'


class MapsMobileExportDevBundle(MapsMobileExportArtifactsBase):

    class Parameters(MapsMobileExportArtifactsBase.Parameters):
        is_navi = True
        platform = None
        is_upload = sdk2.parameters.Bool('Upload to dist?', default=True, required=True)

    def on_execute(self):
        super(MapsMobileExportDevBundle, self).on_execute()
        self._package_idl_app()
        if self.Parameters.release_version > _LAST_BRANCH_WITHOUT_PROTOC or 'trunk' in self.Parameters.arcadia_url:
            self._package_protoc()

    def _package_idl_app(self):
        SubtaskRunner(self).run_and_handle_result('MAPS_MOBILE_MAKE_TOOLS', {
            'arcadia_url': self.Parameters.arcadia_url,
            'building_pkg_json_path': 'tools/idl/package/pkg.json',
            'release_version': self.Parameters.release_version,
            'is_upload': self.Parameters.is_upload,
        }, tag='package_idl_app')

    def _package_protoc(self):
        SubtaskRunner(self).run_and_handle_result('MAPS_MOBILE_MAKE_TOOLS', {
            'arcadia_url': self.Parameters.arcadia_url,
            'building_pkg_json_path': 'contrib/tools/protoc_std/package/pkg.json',
            'release_version': self.Parameters.release_version,
            'is_upload': self.Parameters.is_upload,
        }, tag='package_protoc')
