from sandbox import sdk2

from sandbox.projects.maps.mobile.MapsMobileExportArtifactsBase \
        import MapsMobileExportArtifactsBase


class MapsMobileExportNaviArtifacts(MapsMobileExportArtifactsBase):
    """ Task for packaging Navi artifacts. """

    class Parameters(MapsMobileExportArtifactsBase.Parameters):
        is_navi = True
        is_upload = sdk2.parameters.Bool('Upload to dist?', default=True, required=True)
        with sdk2.parameters.String('Platform', required=True) as platform:
            for pl in ('android', 'ios', 'linux', 'darwin'):
                platform.values[pl] = platform.Value(pl, default=(pl == 'android'))
