import logging
import sandbox.common.types.client as ctc
from  sandbox.projects.common.build.YaPackage import YaPackage
from sandbox.yasandbox import manager

class MapsMobileYaPackageDarwin(YaPackage):
    type = "MAPS_MOBILE_YA_PACKAGE_DARWIN"
    cores = 4
    client_tags = ctc.Tag.CUSTOM_MAPS_MOBILE_DARWIN & ctc.Tag.USER_MAPS_MOBILE_DARWIN
    execution_space = 20 * 1024

    def __init__(self, task_id=0):
        YaPackage.__init__(self, task_id)
        self.ctx['kill_timeout'] = 6 * 60 * 60

    def on_execute(self):
        YaPackage.on_execute(self)
        logging.info('Setting ttl 7 on log resource {}.'.format(self._log_resource.id))
        self._log_resource.attrs['ttl'] = 7
        manager.resource_manager.update(self._log_resource)
