# -*- coding: utf-8 -*-

import logging

from sandbox.projects.common.build.YaMake import YaMakeTask
import sandbox.projects.common.constants as consts
from sandbox.common import rest
import sandbox.common.types.client as ctc


class YaMakeMapsMobile(YaMakeTask):

    type = 'YA_MAKE_MAPS_MOBILE_OSX'

    client_tags = ctc.Tag.CUSTOM_MAPS_MOBILE_DARWIN & ctc.Tag.USER_MAPS_MOBILE_DARWIN_YA_MAKE

    def set_client_tags(self, tags):
        self.ctx[consts.SANDBOX_TAGS] = tags

    def on_enqueue(self):
        if 'requested_client_tags' in self.ctx:
            tags = self.ctx['requested_client_tags'].strip().upper()
            self.set_client_tags(tags)
        YaMakeTask.on_enqueue(self)

    def on_execute(self):
        YaMakeTask.on_execute(self)
        logging.info('Setting ttl 7 on log resource {}.'.format(self._log_resource.id))
        rest.Client().resource[self._log_resource.id].attribute.create({"name": "ttl", "value": 7})


__Task__ = YaMakeMapsMobile
