import os
import tarfile

from sandbox import sdk2


def make_resource(task, resource_type, description, path, content, ttl):
    resource = resource_type(
        task,
        description,
        path,
        ttl=ttl,
        )
    resource_data = sdk2.ResourceData(resource)
    with open(str(resource_data.path), 'wb') as file_:
        file_.write(content)
    resource_data.ready()
    return resource


def extract_resource(resource, path, gzip=True):
    # python2 os.makedirs() does not have an exist_ok parameter.
    if not os.path.isdir(path):
        os.makedirs(path)
    tgz_path = str(sdk2.ResourceData(resource).path)
    mode = 'r:gz' if gzip else 'r'
    with tarfile.open(tgz_path, mode) as tgz:
        tgz.extractall(path)

def apply_navi_export_parameters(resource):
    resource.navi_export_resource = True
    resource.ttl = 'inf'

def get_ya_package_resource(subtask):
    resource = sdk2.Resource['YA_PACKAGE'].find(task=subtask).first()
    if not resource:
        raise TaskError('Could not find YA_PACKAGE resource')
    return resource
