from sandbox.sdk2.helpers import subprocess as sp
from sandbox.common.errors import TaskFailure, TaskError
import sandbox.common.types.task as task_types


def check_call_wrapper(cmd, **kwargs):
    try:
        sp.check_call(cmd, **kwargs)
    except sp.CalledProcessError as error:
        raise TaskFailure('{cmd} failed and finished with {returncode} status code.'.format(cmd=cmd, returncode=error.returncode))


def process_subtask_status(status, error_msg):
    if status == task_types.Status.FAILURE:
        raise TaskFailure(error_msg)
    if status != task_types.Status.SUCCESS:
        raise TaskError(error_msg)
