import io
import os
import stat
import zipfile


def _make_symlink_in_zipfile(zip, target, arcname, permissions=0o777):
    zip_info = zipfile.ZipInfo(arcname)
    zip_info.create_system = 3  # which means UNIX, see paragraph 4.4.2
                                # here: https://pkware.cachefly.net/webdocs/casestudies/APPNOTE.TXT
                                # (mirror at Yandex Paste: https://paste.yandex-team.ru/968208/text)
    unix_filemode = stat.S_IFLNK | permissions
    zip_info.external_attr |= unix_filemode << 16
    zip.writestr(zip_info, target)

def pack_into_zip_file(src_dir, src_dir_paths):
    with io.BytesIO() as zip_io:
        with zipfile.ZipFile(zip_io, 'w', zipfile.ZIP_DEFLATED, allowZip64=True) as zip:
            for src_path in src_dir_paths:
                for dir, subdirs, files in os.walk(src_path):
                    for f in subdirs + files:
                        f_abspath = os.path.join(dir, f)
                        arcname = os.path.relpath(f_abspath, os.path.abspath(src_dir))
                        if os.path.islink(f_abspath):
                            _make_symlink_in_zipfile(zip, os.readlink(f_abspath), arcname)
                        if os.path.isfile(f_abspath) and not os.path.islink(f_abspath):
                            zip.write(f_abspath, arcname)
        return zip_io.getvalue()

