from logging import getLogger, info

from sandbox import sdk2
from sandbox.projects.common import task_env
from sandbox.common.types.resource import State
from sandbox.projects import resource_types
from sandbox.projects.mapsearch.common.find_resource import find_latest_resource
from sandbox.projects.mapsearch.common.juggler import juggler_ok
from sandbox.projects.tycoon.TycoonAdverts import TycoonAds
from sandbox.sdk2.helpers import subprocess as sp


maps_search_advert = ['ddmakeev', 'folunin', 'lepetrandr']

indexer_resource_id = 1965920009


class GeoadvertindexerExecutable2(sdk2.Resource):
    '''Geoproduct adverts flags indexer executable file'''
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = maps_search_advert + ['robot-testenv', 'robot-maps-search']
    release_subscribers = maps_search_advert


class MapsDatabaseAdvert2(sdk2.Resource):
    '''Geoproduct adverts data for basesearch (org ids and page ids)'''
    releasable = True
    auto_backup = True
    releasers = maps_search_advert


class BuildMapsDatabaseAdvert2(sdk2.Task):
    '''Produces advert.pb.bin for basesearch'''

    class Requirements(task_env.TinyRequirements):
        pass

    def on_execute(self):
        info('BuildMapsDatabaseAdvert2 launched')

        index_id = find_latest_resource(MapsDatabaseAdvert2, state=[State.READY, State.NOT_READY], can_find_nothing=True)[0]
        maps_ads_id, maps_ads = find_latest_resource(resource_types.TYCOON_ADVERTS, {'released': 'stable'}, 'ads.xml')

        if index_id > maps_ads_id:
            info('No need for update, finishing...')
            juggler_ok('geoproduct_flags_indexing_alive', 'Indexing skipped (nothing to do)')
            return
        info('TYCOON_ADVERTS has been updated since last run')

        navi_ads = find_latest_resource(TycoonAds, {'released': 'stable'}, 'ads.xml')[1]
        indexer = find_latest_resource(GeoadvertindexerExecutable2, {'released': 'stable'}, id=indexer_resource_id)[1]

        info('Launching indexer...')
        index_dir = 'index'
        command = ' '.join([indexer, '-d', index_dir, navi_ads, maps_ads])
        with sdk2.helpers.ProcessLog(self, logger=getLogger("indexing_logger")) as pl:
            sp.Popen(command, shell=True, stdout=pl.stdout, stderr=sp.STDOUT).wait()
        index_resource = MapsDatabaseAdvert2(self, self.Parameters.description, index_dir)
        sdk2.ResourceData(index_resource).ready()
        index_resource.released = 'stable'
        info('Indexing completed')

        juggler_ok('geoproduct_flags_indexing_alive', 'Indexing completed')
        juggler_ok('geoproduct_flags_freshness', 'Index updated')
        info('BuildMapsDatabaseAdvert2 finished')
