from sandbox import sdk2
from sandbox.common.types.misc import DnsType
from sandbox.projects.common import binary_task, task_env
from sandbox.projects.resource_types import OTHER_RESOURCE


SECRET = 'sec-01e39k8t074z1ndjvfkzsrx6aq'
TVM_SECRET = 'sec-01etaadzmh0m767tdq03471ny8'


class CalculateTransitCoverage(binary_task.LastBinaryTaskRelease, sdk2.Task):
    '''Updates YT table with transit coverage'''

    class Requirements(task_env.TinyRequirements):
        dns = DnsType.DNS64

    class Parameters(sdk2.Task.Parameters):
        queries_table_path = sdk2.parameters.String(
            'Path to table with transit queries',
            required=True)

        stats_table_path = sdk2.parameters.String(
            'Path to YT table to write stats',
            required=True)

        two_gis_period = sdk2.parameters.Float(
            'Total time for two gis requests, in hours',
            required=True,
            default=24.0
        )

        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        super(CalculateTransitCoverage, self).on_execute()

        from maps.search.scripts.transit.coverage.lib.coverage import calculate_coverage
        from maps.search.scripts.transit.coverage.lib.writers import append_to_table

        token = sdk2.yav.Secret(SECRET).data()['YT_TOKEN']
        tvm_secret = sdk2.yav.Secret(TVM_SECRET).data()['client_secret']

        resource = OTHER_RESOURCE(
            self, 'Transit coverage generated output', 'transit_output.jsonl'
        )
        resource.ttl = 60  # days
        resource_data = sdk2.ResourceData(resource)

        stats = calculate_coverage(
            self.Parameters.queries_table_path,
            self.Parameters.two_gis_period,
            token,
            tvm_secret,
            resource_data.path
        )
        append_to_table(self.Parameters.stats_table_path, stats, token)
        resource_data.ready()
