from sandbox import sdk2
from sandbox.projects.common import binary_task, task_env
from sandbox.projects.common.juggler import jclient
from sandbox.projects.resource_types import OTHER_RESOURCE


SECRET = 'sec-01e39k8t074z1ndjvfkzsrx6aq'
TVM_SECRET = 'sec-01etaadzmh0m767tdq03471ny8'


class CheckYMapsTransitCoverage(binary_task.LastBinaryTaskRelease, sdk2.Task):
    '''Task to alert if Yandex.Maps transit coverage is low'''

    class Requirements(task_env.TinyRequirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        queries_table_path = sdk2.parameters.String(
            'Path to table with transit queries',
            required=True)

        coverage_threshold = sdk2.parameters.Float(
            'Coverage threshold to trigger alert ([0, 1])',
            required=True)

        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        super(CheckYMapsTransitCoverage, self).on_execute()

        from maps.search.scripts.transit.coverage.lib.coverage import calculate_ymaps_found_rate

        token = sdk2.yav.Secret(SECRET).data()['YT_TOKEN']
        tvm_secret = sdk2.yav.Secret(TVM_SECRET).data()['client_secret']

        resource = OTHER_RESOURCE(
            self, 'Generated output for YMaps transit coverage', 'transit_output.jsonl'
        )
        resource.ttl = 60  # days
        resource_data = sdk2.ResourceData(resource)

        rate = calculate_ymaps_found_rate(
            self.Parameters.queries_table_path,
            token,
            tvm_secret,
            resource_data.path
        )
        self.Context.coverage_rate = rate

        resource_data.ready()

        status = 'OK' if rate > self.Parameters.coverage_threshold else 'CRIT'
        message = 'Coverage = {}\n'.format(rate)
        message += 'Task: https://sandbox.yandex-team.ru/task/{}/view'.format(self.id)
        jclient.send_events_to_juggler(
            'mapsearch_discovery.sandbox', 'transit_coverage', status, message
        )
