from sandbox import sdk2


maps_search_advert = ['ddmakeev', 'folunin', 'lepetrandr']


class GeoproductIndexerExecutable(sdk2.Resource):
    '''Geoproduct adverts indexer executable file'''
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = maps_search_advert + ['robot-testenv', 'robot-maps-search']
    release_subscribers = maps_search_advert


class GeoproductDiffUploaderExecutable(sdk2.Resource):
    '''Geoproduct adverts diff uploader executable file'''
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = maps_search_advert + ['robot-testenv', 'robot-maps-search']
    release_subscribers = maps_search_advert


class GeoproductBucketValidatorExecutable(sdk2.Resource):
    '''Geoproduct adverts bucket validator executable file'''
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = maps_search_advert + ['robot-testenv', 'robot-maps-search']
    release_subscribers = maps_search_advert


geoadv_dev = ['batonius', 'krokoziabla', 'oklimin']


class GeobsIndexerExecutable(sdk2.Resource):
    '''GeoBS indexer executable'''
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = maps_search_advert + geoadv_dev + ['robot-testenv', 'robot-maps-search']
    release_subscribers = maps_search_advert + geoadv_dev


class PORTO_LAYER_ADDRS_ADVERT(sdk2.Resource):
    '''GeoBS executable porto layer'''
    auto_backup = True
    releasable = True
    releasers = maps_search_advert + geoadv_dev + ['robot-testenv', 'robot-maps-search']
    release_subscribers = maps_search_advert + geoadv_dev
