from sandbox import sdk2
from sandbox.projects.common import binary_task, task_env


class UpdateSpsRubricsData(binary_task.LastBinaryTaskRelease, sdk2.Task):
    '''Updates sps tables with rubrics data'''

    class Requirements(task_env.TinyRequirements):
        pass

    class Parameters(sdk2.Task.Parameters):
        db_secret = sdk2.parameters.YavSecret(
            "YAV secret for db connection url",
            required=True,
        )
        yt_secret = sdk2.parameters.YavSecret(
            "YT token secret",
            required=True,
        )
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        super(UpdateSpsRubricsData, self).on_execute()

        from maps.bizdir.sps.db.client import SqlAlchemyClient
        from maps.bizdir.sps.tools.rubrics_loader.lib.loaders import upload_all
        import yt.wrapper as yt

        db_url = self.Parameters.db_secret.data()["MDB_URI"]
        yt_token = self.Parameters.yt_secret.data()["YT_TOKEN"]

        yt_client = yt.YtClient(proxy="hahn", token=yt_token)
        db_client = SqlAlchemyClient(cluster=db_url)
        upload_all(db_client, yt_client)
