import yt.wrapper
from base64 import b64encode
import random
from yandex.maps.proto.search import related_adverts_1x_pb2
from yandex.maps.proto.common2 import metadata_pb2

SETTINGS_TABLE = '//home/maps-search/toponym_adverts/toponym_adverts_data/tables_and_pin_limits'
ORG_TABLE = '//home/maps-search/toponym_adverts/toponym_adverts_data/advertised_orgs_points'
TOPONYM_TABLE = '//home/maps-search/toponym_adverts/toponym_adverts_data/toponym_bounding_boxes'
OUTPUT_TABLE_PREFIX = '//home/maps-search/toponym_adverts/'


def make_snippet(ads):
    metadata = metadata_pb2.Metadata()
    place = metadata.Extensions[related_adverts_1x_pb2.GEO_OBJECT_RELATED_ADVERTS_SNIPPET].nearby_on_map
    for ad in ads:
        place_info = place.add()
        place_info.uri = "ymapsbm1://org?oid=" + str(ad['permalink'])
        place_info.name = ad['name']
        short_name = ad.get('short_name')
        if short_name and short_name != place_info.name:
            place_info.short_name = short_name
        place_info.point.lon = ad['lon']
        place_info.point.lat = ad['lat']
        rubric = ad.get('rubric_class')
        if rubric:
            place_info.tag.append("icon:" + rubric)
        else:
            place_info.tag.append("fallback")  # FIXME(folunin) after MAPSANDROID-11577
    return b64encode(metadata.SerializeToString())


def cell(lon, lat):
    return (int(lon*10), int(lat*10))


def rectangle(left_bottom, right_top):
    return (
        (i, j)
        for i in xrange(left_bottom[0], right_top[0])
        for j in xrange(left_bottom[1], right_top[1])
    )


def make_tables(token):
    yt_client = yt.wrapper.YtClient(proxy='hahn', token=token)
    output_tables_settings = [row for row in yt_client.read_table(SETTINGS_TABLE)]

    orgs = {}
    for org in yt_client.read_table(ORG_TABLE):
        key = cell(org['lon'], org['lat'])
        orgs.setdefault(key, []).append({
            'name': org['name'],
            'short_name': org['short_name'],
            'permalink': org['permalink'],
            'rubric_class': org['rubric_class'],
            'lon': org['lon'],
            'lat': org['lat']
        })

    def mapper(row):
        left_bottom = cell(row['min_lon'], row['min_lat'])
        right_top = cell(row['max_lon'], row['max_lat'])
        ads = [
            org
            for key in rectangle(left_bottom, [i + 1 for i in right_top])
            for org in orgs.get(key, [])
            if row['min_lon'] <= org['lon'] <= row['max_lon'] and row['min_lat'] <= org['lat'] <= row['max_lat']
        ]
        if ads:
            for table_index, pin_limits in enumerate(output_tables_settings):
                cur_ads = random.sample(ads, min(len(ads), pin_limits[row['kind']]))
                yield yt.wrapper.create_table_switch(table_index)
                yield {
                    'key': 'geocoder_id_' + str(row['geocoder_id']),
                    'value': make_snippet(cur_ads)
                }

    yt_client.run_map(mapper, TOPONYM_TABLE, [OUTPUT_TABLE_PREFIX + settings['name'] for settings in output_tables_settings])

    return 'Generated {} rows'.format(yt_client.row_count(OUTPUT_TABLE_PREFIX + output_tables_settings[0]['name']))
