import logging

from sandbox import sdk2
from sandbox.common.types.task import Status
from sandbox.projects.mapsearch.UpdateToponymAdverts.UpdateAdvertisedOrgsPoints import UpdateAdvertisedOrgsPoints
from sandbox.projects.mapsearch.UpdateToponymAdverts.UpdateToponymBoundingBoxes import UpdateToponymBoundingBoxes
from sandbox.projects.mapsearch.UpdateToponymAdverts.UploadAdvertisedOrgsIdsToYt import UploadAdvertisedOrgsIdsToYt
from sandbox.projects.mapsearch.UpdateToponymAdverts.UpdateRelatedAdverts import UpdateRelatedAdverts
from sandbox.sandboxsdk import environments


class UpdateToponymAdverts(sdk2.Task):
    '''Updates data for toponym adverts snippets'''

    class Requirements(sdk2.Task.Requirements):
        environments = [
            environments.PipEnvironment('yql')
        ]

    def run_subtask_and_wait(self, subtask_type):
        subtask_class = sdk2.Task[subtask_type]
        subtask = subtask_class(self, owner=self.owner)
        subtask.enqueue()
        self.Context.subtask_id = subtask.id
        raise sdk2.WaitTask([self.Context.subtask_id], Status.Group.FINISH | Status.Group.BREAK, wait_all=True)

    def on_execute(self):
        logging.info('UpdateToponymAdverts launched')

        with self.memoize_stage.upload_advertised_orgs_ids_to_yt:
            self.run_subtask_and_wait(UploadAdvertisedOrgsIdsToYt.type)

        with self.memoize_stage.update_advertised_orgs_points:
            self.run_subtask_and_wait(UpdateAdvertisedOrgsPoints.type)

        with self.memoize_stage.update_toponym_bounding_boxes:
            self.run_subtask_and_wait(UpdateToponymBoundingBoxes.type)

        with self.memoize_stage.update_related_adverts:
            self.run_subtask_and_wait(UpdateRelatedAdverts.type)

        logging.info('UpdateToponymAdverts finished')
