from logging import info

from sandbox import sdk2
from sandbox.common.types.resource import State
from sandbox.sandboxsdk import errors


def find_latest_resource(resource_type, attrs={}, file_name='', state=[State.READY], can_find_nothing=False, id=None):
    info('Searching for latest stable %s resource...' % str(resource_type))

    resource = None
    for specific_state in state:
        specific_resource = sdk2.Resource.find(resource_type, id=id, state=specific_state, attrs=attrs).limit(1).first()
        if specific_resource is not None and (resource is None or specific_resource.id > resource.id):
            resource = specific_resource

    if resource is None:
        if can_find_nothing:
            info('No %s resource found' % str(resource_type))
            return -1, None
        else:
            raise errors.SandboxTaskFailureError('No %s resource found' % str(resource_type))

    info('Found %s resource with id=%d' % (str(resource_type), resource.id))

    file_path = ''
    if resource.state == State.READY:
        file_path = sdk2.ResourceData(resource).path.joinpath(file_name)
        if not file_path.exists():
            raise errors.SandboxTaskFailureError('File %s not found' % file_path)

    return resource.id, str(file_path)
