# coding=utf-8
import logging
import requests
import time
import json

from sandbox import sdk2
from sandbox.sdk2 import environments
from sandbox.common.telegram import TelegramBot


class WmsSupportRestartingOrder(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):

        with sdk2.parameters.Group("WMS database settings", collapse=True) as wms_db_settings:
            database_user_secret = sdk2.parameters.YavSecret(
                'WMS database username'
                '\nYAV secret identifier (with optional version)'
                '\nDefault key: username',
                required=True
            )
            database_password_secret = sdk2.parameters.YavSecret(
                'WMS database password '
                '\nYAV secret identifier (with optional version)'
                '\nDefault key: password',
                required=True
            )
            database_host_string = sdk2.parameters.String('host1, host2,...', required=True)
            database_port_string = sdk2.parameters.String('port1, port2,...', required=True)
            database_warehouse_string = sdk2.parameters.String('warehouse1, warehouse2,...', required=True)
            telegram_bot_token_vault_key = sdk2.parameters.String('Telegram bot token key', required=True)
            telegram_chat_id = sdk2.parameters.String('Telegram chat id', required=True)

    class Requirements(sdk2.Requirements):
        disk_space = 1024 * 5
        environments = (
            environments.PipEnvironment('pymssql==2.1.4'),
            environments.PipEnvironment('yandex_tracker_client', version="1.3",
                                        custom_parameters=["--upgrade-strategy only-if-needed"]),
            environments.PipEnvironment('startrek_client', version="2.3.0",
                                        custom_parameters=["--upgrade-strategy only-if-needed"]),
        )

    def get_list(self, array):
        result = []
        parts = array.split(';')
        for part in parts:
            trimmed_part = part.strip()
            result.append(trimmed_part)
        return result

    def get_table(self, ms, host, port,database_user, database_password):
        mes = '\'' + ms + '\''
        conn = self.wms_connection(host, port, database_user, database_password)
        execution = 'select status, orderkey from SCPRD.wmwhse1.ORDERS where orderkey = ' + mes
        conn.execute(execution)
        row = conn.fetchone()
        result = []
        while row:
            result.append(row[0])
            result.append(row[1])
            row = conn.fetchone()
        return result

    def wms_closed_connection(self, conn):
        conn.close()
        logging.info('WMS database connection closed.')

    def wms_connection(self, host, port, user, password):
        conn = None
        logging.info('Connecting to the WMS database...')
        logging.info('User: {}'.format(user))
        _pymssql = __import__('pymssql')
        conn = _pymssql.connect(
            user=user,
            password=password,
            host=host,
            port=port
        )
        logging.info('Connected')
        return conn

    def on_execute(self):
        bot = TelegramBot(bot_token=sdk2.Vault.data(self.Parameters.telegram_bot_token_vault_key))
        hosts = self.get_list(self.Parameters.database_host_string)
        ports = self.get_list(self.Parameters.database_port_string)
        warehouses = self.get_list(self.Parameters.database_warehouse_string)
        database_user = self.Parameters.database_user_secret.data()
        database_user_key = self.Parameters.database_user_secret.default_key or 'username'
        database_user = database_user[database_user_key]
        database_password = self.Parameters.database_password_secret.data()
        database_password_key = self.Parameters.database_password_secret.default_key or 'password'
        database_password = database_password[database_password_key]
        update = bot.get_updates(offset=-1)
        last_update = update["result"]
        logging.info(last_update)
        tmp1 = last_update[0]
        logging.info(tmp1)
        tmp2 = bot.get_updates(tmp1)
        logging.info(tmp2)


