# coding=utf-8

from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment
from datetime import datetime, timedelta
import requests


class WmsSlaHelper(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [PipEnvironment('startrek_client')]

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group("Settings", collapse=True) as wms_db_settings:
            search_issues = sdk2.parameters.String('search_issues', required=True)
            chat_id = sdk2.parameters.String('chat_id', required=True)
            alert_min = sdk2.parameters.Integer('alert_min', required=True, default=11)

    def on_execute(self):
        from startrek_client import Startrek
        secret = sdk2.yav.Secret('sec-01g38w5733kwbysy07p237ddj4')
        st_token = secret.data()['treck-oauth']
        secret2 = sdk2.yav.Secret('sec-01g9051x7zxb8zq90exbxnrc9c')
        tg_token = secret2.data()['RobokotovaBot']
        client = Startrek(useragent="python", token=st_token)
        st_link = "https://st.yandex-team.ru/"
        sla_issues = client.issues.find(self.Parameters.search_issues)
        for i in sla_issues:
            for k in i.sla:
                if k['clockStatus'] == "STARTED" and k['failAt']:
                    current_time = datetime.now() - timedelta(hours=3)
                    fail_sla_time = datetime.strptime((k['failAt']).replace('+0000', ''), "%Y-%m-%dT%H:%M:%S.%f")
                    to_fail = round((fail_sla_time - current_time).total_seconds() / 60)
                    if to_fail < int(self.Parameters.alert_min):
                        message_text = u'\U0001f4a5 <b>SLA истекает</b> \U0001f4a5\n' + '<i>' + i.summary + \
                                       '</i>\n'+'<a href="' + st_link + i.key + '">' + i.key + '</a>'
                        request_url = "https://api.telegram.org/bot" + tg_token + "/sendMessage"
                        data = {"chat_id": self.Parameters.chat_id, "parse_mode": "html", "text": message_text}
                        requests.post(request_url, data=data)
                        current_tags = i.tags
                        new_tag = "sla_helper"
                        current_tags.append(new_tag)
                        i.update(tags=current_tags)
