# coding=utf-8

import os
import re

from sandbox import sdk2


class AffiliateStatoscopeReport(sdk2.Resource):
    browser = sdk2.resource.Attributes.String('Browser type')
    env = sdk2.resource.Attributes.String('Enviroment type')


class MarketAffiliateStatoscopeStats(sdk2.Task):
    """
    Таска для генерации ресурсов с эталонными статистиками для статоскопа

    Таска берет ресурс из проверки в github и собирает каждый файл со статистикой в отдельный ресурс.
    """

    class Parameters(sdk2.Task.Parameters):
        resource_id = sdk2.parameters.Resource('resource')

    def on_execute(self):
        resource = sdk2.Resource[self.Parameters.resource_id]

        resource_data = sdk2.ResourceData(resource)

        resource_path = str(resource_data.path)

        stats_path = os.path.join(resource_path, 'statoscope', 'stats')

        stat_files = list(map(lambda x: os.path.join(stats_path, x), os.listdir(stats_path)))

        for stat_file in stat_files:
            self._generate_resource_by_file(stat_file)

    def _generate_resource_by_file(self, filepath):
        name = os.path.basename(filepath)

        parsed_name = self._parse_filename(name)

        resource = AffiliateStatoscopeReport(self, "File", name)
        resource.browser = parsed_name['browser']
        resource.env = parsed_name['env']

        with open(filepath, 'r') as fin:
            resource.path.write_bytes(fin.read())

    def _parse_filename(self, filename):
        parsed_name = re.search('(.*)-(.*)-', filename)

        return {
            'browser': parsed_name.group(1),
            'env': parsed_name.group(2)
        }
