import requests
import logging
import shutil
from sandbox import sdk2
from sandbox.projects.tank.load_resources import resources


class BackupTankLogs(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        tank = sdk2.parameters.String('tank', required=True)
        shooting_id = sdk2.parameters.String('shooting_id', required=True)
        ttl = sdk2.parameters.Float('ttl', required=True)

    def on_execute(self):

        file_list_url = '{tank}/api/v1/tests/{shooting_id}/logs.json'.format(tank=self.Parameters.tank, shooting_id=self.Parameters.shooting_id)
        logging.info('Get list of files from %s', file_list_url)
        res = requests.get(file_list_url)
        files = res.json()['files']
        data = sdk2.ResourceData(resources.YANDEX_TANK_LOGS(self, "Yandex tank logs", "tank_logs", ttl=self.Parameters.ttl))
        data.path.mkdir(0755, parents=True, exist_ok=True)
        for file_name in files:
            file_url = '{tank}/api/v1/tests/{shooting_id}/logs/{file_name}'.format(tank=self.Parameters.tank, shooting_id=self.Parameters.shooting_id, file_name=file_name)
            logging.info('Start loading file %s from %s', file_name, file_url)
            file_request = requests.get(file_url, stream=True)
            path = data.path.joinpath(file_name)
            with path.open(mode='wb') as output:
                shutil.copyfileobj(file_request.raw, output)
            logging.info('File %s saved on disk', file_name)
        data.ready()
