# -*- coding: utf-8 -*-

import logging

from sandbox import sdk2
from sandbox import common
from sandbox.sandboxsdk import environments

turn_on_action = "Включить чат магазина"
turn_off_action = "Отключить чат магазина"
table_path = 'home/market/production/chats/disabled_shops'


class ChangeMarketShopChatStatus(sdk2.Task):
    """Block/Unblock chat for market shop"""

    class Requirements(sdk2.Task.Requirements):
        disk_space = 300
        environments = (
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yql'),
        )

    class Parameters(sdk2.Task.Parameters):
        action = sdk2.parameters.String(
            "Действие",
            choices=[(turn_on_action, turn_on_action), (turn_off_action, turn_off_action)],
            default=turn_on_action
        )

        yql_token_name = sdk2.parameters.String(
            "YQL token name",
            default='YQL_TOKEN',
            required=True
        )

        shop_id = sdk2.parameters.String(
            "ID магазина",
            required=True
        )

    def is_shop_exists(self, shop_id):
        import yql.api.v1.client

        yql_token = sdk2.Vault.data(self.Parameters.yql_token_name)
        yql_query = "SELECT DISTINCT shop_id FROM hahn.`{table_path}` WHERE shop_id == {shop_id}".format(
            table_path=table_path,
            shop_id=shop_id
        )

        with yql.api.v1.client.YqlClient(token=yql_token) as yql_client:
            logging.info(yql_query)
            query = yql_client.query(yql_query)
            query.run()

            if not query.get_results().is_success:
                raise common.errors.TaskFailure("YQL запрос не выполнен: " + '; '.join(str(error) for error in query.get_results().errors))

            for table in query.get_results():
                table.fetch_full_data()

                return len(table.rows) > 0

    def on_execute(self):
        import yql.api.v1.client

        yql_token = sdk2.Vault.data(self.Parameters.yql_token_name)
        shop_id = self.Parameters.shop_id
        is_shop_disabled = self.is_shop_exists(shop_id)
        turn_on = self.Parameters.action == turn_on_action
        turn_off = not turn_on

        if turn_on and not is_shop_disabled:
            raise common.errors.TaskFailure("Чат магазина с shop_id = {shop_id} не был выключен".format(shop_id=shop_id))

        if turn_off and is_shop_disabled:
            raise common.errors.TaskFailure("Чат магазина с shop_id = {shop_id} уже выключен".format(shop_id=shop_id))

        if turn_on:
            yql_query = """
                INSERT INTO hahn.`{table_path}` WITH TRUNCATE
                SELECT DISTINCT shop_id FROM hahn.`{table_path}` WHERE shop_id != {shop_id}
            """.format(
                table_path=table_path,
                shop_id=shop_id
            )
        else:
            yql_query = """
            INSERT INTO
              hahn.`{table_path}` (shop_id)
            VALUES
              ({shop_id});
            """.format(
                table_path=table_path,
                shop_id=shop_id
            )

        with yql.api.v1.client.YqlClient(token=yql_token) as yql_client:
            logging.info(yql_query)
            query = yql_client.query(yql_query)
            query.run()

            if not query.get_results().is_success:
                raise common.errors.TaskFailure("YQL запрос не выполнен: " + '; '.join(str(error) for error in query.get_results().errors))
