from sandbox import sdk2

from sandbox.projects.common.binary_task import deprecated as binary_task


class CleanUserData(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        binary_task.LastBinaryTaskRelease.on_execute(self)
        ya_login = 'robot-market-chkout'
        st_token = sdk2.Vault.data(ya_login, 'ST_TOKEN')
        ssh_key = sdk2.Vault.data(ya_login, 'robot-market-chkout-ssh')
        from market.checkout.utils.process_gdpr_tickets import process_gdpr_tickets
        process_gdpr_tickets(ya_login, st_token, ssh_key)
