# coding=UTF8
from sandbox import sdk2
from sandbox.sdk2 import yav
from escalator import Escalator
import sandbox.projects.common.environments as env


class MarketAlertEscalation(sdk2.Task):
  class Requirements(sdk2.Requirements):
    environments = [env.PipEnvironment("python-dateutil")]

  class Parameters(sdk2.Task.Parameters):
    service_responsible = sdk2.parameters.String('Responsible for the service(telegram username):', default='gelvy')
    calendar_id = sdk2.parameters.Integer('FM duty calendar ID:', default=3085)
    transition_hour = sdk2.parameters.Integer('FM transition hour:', default=11)
    start_hour = sdk2.parameters.Integer('Start notification hour:', default=10)
    end_hour = sdk2.parameters.Integer('End notification hour:', default=21)
    start_weekday = sdk2.parameters.Integer('Start notification weekday', default=0)
    end_weekday = sdk2.parameters.Integer('Start notification weekday', default=4)
    notify_filter_id = sdk2.parameters.Integer('Notify filter ID', default=0)
    stuck_filter_id = sdk2.parameters.Integer('Stuck filter ID', default=0)
    escalation_filter_id = sdk2.parameters.Integer('Escalation filter ID', default=0)
    escalation_enabled = sdk2.parameters.Bool('Enable escalation', default=True)
    reminder_enabled = sdk2.parameters.Bool('Enable first reaction reminder', default=True)
    stuck_enabled = sdk2.parameters.Bool('Enable stuck ticket reminder', default=False)

  def on_execute(self):
    yav_tokens = yav.Secret('sec-01dz6ebf34gs5sj9g47asjrmc5')
    escalator = Escalator(yav_tokens,
                          self.Parameters.calendar_id,
                          self.Parameters.transition_hour,
                          self.Parameters.notify_filter_id,
                          self.Parameters.stuck_filter_id,
                          self.Parameters.escalation_filter_id,
                          self.Parameters.escalation_enabled,
                          self.Parameters.reminder_enabled,
                          self.Parameters.stuck_enabled,
                          self.Parameters.start_weekday,
                          self.Parameters.end_weekday,
                          self.Parameters.start_hour,
                          self.Parameters.end_hour,
                          self.Parameters.service_responsible)

    escalator.do_escalation()
