USE marketclickhouse;

select
    http_method,
    method,
    rgb,
    round(avg(q95_rps), 2) as current_rps
from (
select date as period, http_method, method, rgb, quantile(0.95)(rps) as q95_rps from (
    select
    date,
    http_method,
    CASE WHEN consolidate == 'true' THEN method || '_consolidate' ELSE method END as method,
    rgb,
    timestamp,
    count(1) as rps from (
        select
                timestamp,
                http_method,
                CASE when method = '' or method is null  THEN
                    CASE when url like '/cart/UID/%/list' then 'carter_uid_list'
                        when url like '/cart/YANDEXUID/%/list' then 'carter_yandexuid_list'
                        when url like '/cart/UUID/%/list' then 'carter_uuid_list'
                        when url like '/cart/UID/%/list/%/item' then 'carter_uuid_list_item'
                    ELSE 'empty_method' END
                ELSE method END as method,
                date,
                kv_values[indexOf(kv_keys, 'param.rgb')] as rgb,
                kv_values[indexOf(kv_keys, 'param.consolidate')] as consolidate
        from market.carter2
        where date = today() - 1
        and url not in ('/ping', '/ping-ext') and url not like '/monitor%' and url not like '%/pagematch%'
        and (http_method, method) not in (('PATCH', 'carter_uuid_list'), ('DELETE', 'carter_uuid_list_item'),
                                                                                  ('PATCH', 'carter_uuid_list_items'))
    )
    group by date, http_method, method, rgb, timestamp
)
group by period, http_method, method, rgb
having sum(rps) > 1000
)
group by http_method, method, rgb
order by current_rps desc
;
