import json
import logging as log

import requests


def add_items(user_type, user_id, items):
    url = 'http://iva1-5521-e07-iva-market-test--b9a-25063.gencfg-c.yandex.net:25063' \
          '/cart/{user_type}/{user_id}/list/-1/items' \
        .format(user_type=user_type, user_id=user_id)
    body = {
        "listType": "BASKET",
        "items": items
    }
    r = requests.post(url=url,
                      params={'rgb': 'BLUE'}, data=json.dumps(body), headers={'Content-Type': 'application/json'})
    if r.status_code != 200:
        log.warn(
            ('failed to create items. Server response: {} {} '
             '\nURL: POST ' + url +
             '\nBody: {} ').format(r.status_code, r.text, json.dumps(body)))
