import logging as log

from constants import ITEM_TO_DELETE_PREFIX
from concurrent.futures import TimeoutError


class DataBase:
    def __init__(self, yql_token):
        self.yql_token = yql_token

    def fetch_yandexuid_items(self):
        return self.__fetchall('''SELECT DISTINCT user_id as yandexuid, item_id
            FROM cart_item
            WHERE user_type='YANDEXUID'
            AND obj_type='OFFER'
            AND name NOT LIKE '{}%';'''.format(ITEM_TO_DELETE_PREFIX))

    def fetch_uid_items(self):
        return self.__fetchall('''SELECT DISTINCT user_id as uid, item_id
            FROM cart_item
            WHERE user_type='UID'
            AND obj_type='OFFER'
            AND name NOT LIKE '{}%';'''.format(ITEM_TO_DELETE_PREFIX))

    def fetch_uid_items_to_delete(self):
        return self.__fetchall('''SELECT DISTINCT user_id as uid, item_id
            FROM cart_item
            WHERE user_type='UID'
            AND obj_type='OFFER'
            AND name LIKE '{}%';'''.format(ITEM_TO_DELETE_PREFIX))

    def fetch_uids_and_free_item_slots_count(self, max_items):
        return self.__fetchall('''
            SELECT user_id as uid,
                CASE WHEN count(user_id) > {} THEN 0 ELSE {} - count(user_id) END as cnt
            FROM cart_item
            WHERE user_type='UID'
            GROUP BY user_id;'''.format(max_items, max_items))

    def fetch_uuid_items(self):
        return self.__fetchall('''SELECT DISTINCT user_id as `uuid`, item_id
            FROM cart_itemYANDEXUID
            WHERE user_type='UUID'
            AND obj_type='OFFER'
            AND name NOT LIKE  '{}%';'''.format(ITEM_TO_DELETE_PREFIX))

    def fetch_yandexuids_with_basket(self):
        return self.extract_single_element_from_tuple(self.__fetchall('''
        SELECT DISTINCT user_id FROM cart_item WHERE obj_type = 'OFFER' AND user_type = 'YANDEXUID'
        '''))

    def fetch_uids_with_basket(self):
        return self.extract_single_element_from_tuple(self.__fetchall('''
        SELECT DISTINCT user_id FROM cart_item WHERE user_type='UID' AND obj_type='OFFER'
        '''))

    def fetch_uuids_with_basket(self):
        return self.extract_single_element_from_tuple(self.__fetchall('''
        SELECT DISTINCT user_id FROM cart_item WHERE obj_type = 'OFFER' AND user_type = 'UUID'
        '''))

    def extract_single_element_from_tuple(self, array):
        return list(map(lambda e: e[0], array))

    def __fetchall(self, sql):
        result_sets = self.__new_connection().transaction().execute(sql)
        log.debug('fetched {} rows from YDB'.format(len(result_sets[0].rows)))
        return result_sets[0].rows

    def __new_connection(self):
        try:
            import ydb
            connection_params = ydb.DriverConfig(endpoint="ydb-ru-prestable.yandex.net:2135",
                                                 database="/ru-prestable/checkouter/load/market-carter",
                                                 auth_token=self.yql_token)
            driver = ydb.Driver(connection_params)
            driver.wait(timeout=5)
            return driver.table_client.session().create()
        except TimeoutError:
            raise RuntimeError("Connect failed to YDB")


if __name__ == '__main__':
    db = DataBase('password')

    # print(random.choice(db.fetch_yandexuids_with_basket()))
    # print(len(db.fetch_yandexuid_items()))
    # print(len(db.fetch_uuid_items()))
    # print(len(db.fetch_uid_items()))
    # print(len(db.fetch_uid_items_to_delete()))
    print(db.fetch_yandexuids_with_basket())
