# util method for generating ammo
def make_ammo(method, url, tag="", headers='Host: gravicapa01ht.market.yandex.net', body=None):
    """
        Makes phantom ammo
        http://yandextank.readthedocs.org/en/latest/ammo_generators.html
    """

    # http request w/o entity body template
    req_template = (
        "%s %s HTTP/1.1\n"
        "%s\n"
        "\n"
    )

    # http request with entity body template
    req_template_w_entity_body = (
        "%s %s HTTP/1.1\n"
        "%s\n"
        "Content-Type: application/json\n"
        "Content-Length: %d\n"
        "\n"
        "%s\n"
    )

    if not body:
        req = req_template % (method, url, headers)
    else:
        req = req_template_w_entity_body % (method, url, headers, len(body), body)

    # phantom ammo template
    ammo_template = (
        "%d%s\n"
        "%s"
    )

    return ammo_template % (len(req), ' ' + tag if len(tag) > 0 else '', req)
