import csv
import logging as log

base_path = 'sandbox/projects/market/checkout/MarketCarterLoadGenerateAmmo/'


def load_uids():
    uids = []
    f = read_resource('uids.tsv')

    for line in f.splitlines():
        if line:
            uids.append(int(line))
    return uids


def load_yandexuids():
    yandexuids = []
    f = read_resource('yandexuids.tsv')
    for line in f.splitlines():
        if line:
            yandexuids.append(int(line))
    return yandexuids


def load_fee_shows():
    f = read_resource('fee_shows')
    fee_shows = f.splitlines()
    return [x.strip() for x in fee_shows]


def load_api_methods(rps_csv_lines):
    result = []
    ammo_reader = csv.reader(rps_csv_lines, delimiter=',', quotechar='"')
    for row in ammo_reader:
        log.debug('reading row: ' + str(row))
        result.append({
            "http_method": row[0],
            "method_name": row[1],
            "rgb": row[2],
            "rps_multiplier": row[3]
        })
    return result


def read_resource(file_name):
    import library.python.resource as resource
    return resource.find(base_path + file_name)
