# coding=UTF8
from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.sandboxsdk import environments
from autoduty import Autoduty
import logging


class MarketCheckouterAutoduty(sdk2.Task):
  """Автоматизация заступления на дежурство"""

  class Requirements(sdk2.Task.Requirements):
    environments = (environments.PipEnvironment('caldav'),)

  class Parameters(sdk2.Parameters):
    calendar_id = sdk2.parameters.Integer('FM duty calendar ID:', default=3085)
    transition_hour = sdk2.parameters.Integer('FM transition hour:', default=11)

  def on_execute(self):
    logging.info("Getting secrets from yav...")
    yav_tokens = yav.Secret('sec-01dz6ebf34gs5sj9g47asjrmc5')

    logging.info("Constructing...")
    autoduty = Autoduty(yav_tokens.data()['startrek_oauth_token'],
                        yav_tokens.data()['telegram_bot_token'],
                        yav_tokens.data()['abc_token'],
                        self.Parameters.calendar_id,
                        self.Parameters.transition_hour)
    logging.info("Executing...")
    autoduty.run()
