# coding=UTF8
import requests
import logging
import json
from datetime import datetime, timedelta
from startrek_provider import StartrekProvider
from sandbox.projects.release_machine.helpers.staff_helper import StaffApi

class Autoduty():
  def __init__(self,
               startrek_oauth_token,
               telegram_bot_token,
               abc_token,
               calendar_id,
               transition_hour):
    self.abc_api_url = 'https://abc-back.yandex-team.ru/api/v4/duty/shifts/?service__slug=checkouter&date_from={}&date_to={}&schedule={}&with_watcher=1'
    self.abc_token = abc_token
    self.calendar_id = calendar_id
    self.transition_hour = transition_hour
    self.telegram_api_url = 'https://api.telegram.org'
    self.telegram_bot_token = telegram_bot_token
    self.logger = logging.getLogger(__name__)
    self._staff = StaffApi(startrek_oauth_token)
    self.startrek_provider = StartrekProvider(startrek_oauth_token)

  def run(self):

    today = datetime.today()
    tomorrow = datetime.today() + timedelta(days=1)
    yesterday = datetime.today() - timedelta(days=1)

    response = requests.get(self.abc_api_url.format(yesterday.strftime("%Y-%m-%d"), tomorrow.strftime("%Y-%m-%d"), self.calendar_id),
                            headers={'Authorization': 'OAuth {}'.format(self.abc_token)})

    logging.info("Received response from abc {}".format(response.json()))

    duties = response.json()['results']
    for duty in duties:
      fm_duty = duty['person']['login']
      start = datetime.strptime(duty['start'], "%Y-%m-%d").date()
      end = datetime.strptime(duty['end'], "%Y-%m-%d").date()
      if start == today.date():
        self.startrek_provider.create_issue(start, end, fm_duty)
        self.telegram_notify(fm_duty, "<b>На дежурство заступает @{}!</b>\nУдачного дежурства!")
      if end == today.date():
        self.telegram_notify(fm_duty, "<b>Похлопаем нашему дежурному @{}!</b>\nДежурство на сегодня закончено!")

    self.startrek_provider.actualize_issues_status()

  def telegram_notify(self, assignee, text):
    contacts = self._staff.get_person_profile_property(assignee, 'telegram_accounts')['telegram_accounts']
    self.logger.info("Found duty staff contacts {}".format(contacts))

    for contact in contacts:
      if 'bot' not in contact['value']:

        result = requests.post(
          '{}/bot{}/sendMessage'.format(self.telegram_api_url, self.telegram_bot_token),
          headers=self.startrek_provider.auth_header(),
          data=json.dumps({
            "chat_id": "-1001324412277",
            "text": text.format(contact['value']),
            "parse_mode": "HTML",
            "method": "sendMessage"
          })
        ).json()
        self.logger.info("Notification sent for contact {} result {}".format(contact, result))

        break
