from sandbox import sdk2

import alerts

class MarketCheckouterCleanAlerts(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        solomon_api_url = sdk2.parameters.String('Solomon api url', default='http://solomon.yandex.net')
        checkouter_url = sdk2.parameters.String('Checkouter url', default='http://checkouter.tst.vs.market.yandex.net:39001')
        project_id = sdk2.parameters.String('Project id', default='market-checkouter-devel')
        oauth_token_vault_key = sdk2.parameters.String('Oauth token vault key', default='market_checkouter_solomon_oauth_token')

    def on_execute(self):
        oauth_token = sdk2.Vault.data('MARKET', self.Parameters.oauth_token_vault_key)

        cleaner = alerts.Cleaner(self.Parameters.solomon_api_url, self.Parameters.checkouter_url, oauth_token, projectId=self.Parameters.project_id)
        cleaner.clean()
