import logging
import os
import requests

class Cleaner(object):
    def __init__(self,
                    solomonApiUrl,
                    checkouterUrl,
                    oauthToken,
                    projectId='market-checkouter-devel'):
        self.solomonApiUrl = solomonApiUrl
        self.checkouterUrl = checkouterUrl
        self.oauthToken = oauthToken
        self.projectId = projectId

    def __make_headers(self):
        return {
            'Authorization': 'OAuth ' + self.oauthToken
        }

    def __get_alerts(self):
        pages_alerts = requests.get(self.checkouterUrl + '/health/solomon').json()
        logging.debug('pages_alerts %d', len(pages_alerts))
        tasks_alerts = requests.get(self.checkouterUrl + '/tasks/health/solomon').json()
        logging.debug('tasks_alerts %d', len(tasks_alerts))
        http_groups = requests.get(self.checkouterUrl + '/monitor/dev/groups').json()
        logging.debug('http_groups %d', len(http_groups))
        
        alert_ids = set()
        for alert in pages_alerts:
            alert_ids.add(alert['id'])
        for alert in tasks_alerts:
            alert_ids.add(alert['id'])
        for group in http_groups:
            alert_ids.add('c-h-m-' + group['groupName'])

        return alert_ids

    def __get_solomon_alerts(self):
        result = []
        pageToken = None

        while True:
            params = {"pageToken": pageToken}

            alerts = requests.get(self.solomonApiUrl + '/api/v2/projects/' + self.projectId + '/alerts', params=params, headers=self.__make_headers()).json()

            pageToken = alerts['nextPageToken'] if 'nextPageToken' in alerts else None
            result.extend(alerts['items'])

            if pageToken is None:
                break

        return result


    def clean(self):
        known_ids = self.__get_alerts()
        logging.debug('known ids: %d', len(known_ids))

        alerts = self.__get_solomon_alerts()
        logging.debug('alerts: %d', len(alerts))

        for alert in alerts:
            alertId = alert['id']
            if alertId not in known_ids:
                logging.info('Alert to delete: ' + alertId)

                requests.delete(self.solomonApiUrl + '/api/v2/projects/{projectId}/alerts/{alertId}'.format(
                    projectId=self.projectId, alertId=alert['id']
                ), headers=self.__make_headers())


def main():
    logging.basicConfig(level=logging.DEBUG)

    oauthToken = os.getenv('SOLOMON_OAUTH')

    cleaner = Cleaner('http://solomon.yandex.net', 'http://checkouter.tst.vs.market.yandex.net:39001', oauthToken)
    cleaner.clean()

if __name__ == '__main__':
    main()