# -*- coding: utf-8 -*-

import errno
import logging

from sandbox import common
from sandbox.projects.common.build.YaMake import YaMakeTask
from sandbox.projects.common.build.sdk import sdk_compat as ya_sdk_compat
from sandbox.projects.common.vcs import arc

CHECKOUTER_DB_REVISION = 'checkouter-db-revision'


class MarketCheckouterDbCompatibilityTests(YaMakeTask):

    type = 'MARKET_CHECKOUTER_DB_COMPATIBILITY_TESTS'

    def get_source_dirs(self, mode):
        try:
            arcadia_ctx, arcadia_tests_data_ctx = ya_sdk_compat.get_source_dirs(self, mode)

            assert CHECKOUTER_DB_REVISION in self.ctx
            revision = self.ctx.get(CHECKOUTER_DB_REVISION)
            arc.Arc().export(arcadia_ctx, revision, 'market/checkout/checkouter-db', '.')

            return arcadia_ctx, arcadia_tests_data_ctx
        except OSError as e:
            if e.errno in [errno.EACCES]:
                logging.exception("Exception while ya_sdk_compat.get_source_dirs")
                raise common.errors.TemporaryError("Unable to get arcadia due to infrastructure error (code {})".format(e.errno))
            raise

