import alerts

import json
import os
import requests

from sandbox import sdk2

class MarketCheckouterGenerateAlerts(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        solomon_url = sdk2.parameters.String('Solomon api url', default='https://solomon.yandex.net')
        application_url = sdk2.parameters.String('Application url', default='http://checkouter.tst.vs.market.yandex.net:39001')
        application_path = sdk2.parameters.String('Application path', default='/health/solomon')
        project_id = sdk2.parameters.String('Project id', default='market-checkouter-devel')
        oauth_token_vault_key = sdk2.parameters.String('Oauth token vault key', default='market_checkouter_solomon_oauth_token')
    
    def on_execute(self):
        solomon_project_url = self.Parameters.solomon_url + '/api/v2/projects/' + self.Parameters.project_id
        oauth_token = sdk2.Vault.data('MARKET', self.Parameters.oauth_token_vault_key)

        generator = alerts.AlertGenerator(oauth_token, solomon_project_url, self.Parameters.application_url, self.Parameters.project_id, self.Parameters.application_path)
        generator.generate()

