import logging
import json
import os
import requests

class AlertGenerator(object):
    def __init__(self,
                  oauthToken,
                  solomonUrl,
                  applicationUrl,
                  projectId,
                  applicationPath
        ):
        self.oauthToken = oauthToken
        self.solomonUrl = solomonUrl
        self.applicationUrl = applicationUrl
        self.projectId = projectId
        self.headers = {"Authorization": "OAuth " + self.oauthToken, "Content-Type": "application/json"}
        self.applicationPath = applicationPath


    def generate(self):
        response = requests.get(self.applicationUrl + self.applicationPath, headers={"IgnoreTvmCheck": "true"})

        if response.status_code <> requests.codes.ok:
            logging.info(self.applicationUrl + self.applicationPath + " response status is: %d", response.status_code)
            return

        alerts = response.json()
        has_errors = False
        logging.info("loaded %d alerts from %s", len(alerts), self.applicationUrl + self.applicationPath)
        for alert in alerts:
            alert['id'] = alert['id'].replace('.', '_')

            alertUrl = self.solomonUrl + '/alerts/' + alert['id']
            alertResponse = requests.get(alertUrl, headers=self.headers)

            if alertResponse.status_code == requests.codes.ok:
                logging.info('alert %s found... update it', alert['id'])
                loaded = json.loads(alertResponse.content)
                alert['version'] = loaded['version']
                p = requests.put(alertUrl, headers=self.headers, json=alert);
                if p.status_code <> requests.codes.ok:
                    logging.error(p.content)
                    has_errors = True
            else:
                logging.info('alert %s not found... post it', alert['id'])
                logging.debug('alert: %s', json.dumps(alert))
                p = requests.post(self.solomonUrl + '/alerts', headers=self.headers, json=alert)
                if p.status_code <> requests.codes.ok:
                    logging.error(p.content)
                    has_errors = True

        if has_errors:
            raise Exception("There are some errors, please read log...")

def main():
    logging.basicConfig(level=logging.DEBUG)

    oauthToken = os.environ['SOLOMON_OAUTH']
    projectId = "market-checkouter-devel"
    projectUrl = "http://solomon.yandex.net/api/v2/projects/{}".format(projectId)
    applicationUrl = "http://checkouter.tst.vs.market.yandex.net:39001"
    applicationPath  = '/tasks/health/solomon'

    generator = AlertGenerator(oauthToken, projectUrl, applicationUrl, projectId, applicationPath)
    generator.generate()

if __name__ == '__main__':
    main()
