import dashboard
import json

from sandbox import sdk2
from sandbox.projects.market.checkout.helpers.solomon import Solomon

class MarketCheckouterGenerateAlertsDashboard(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        solomon_api_url = sdk2.parameters.String('Solomon api url', default='http://solomon.yandex.net')
        solomon_url = sdk2.parameters.String('Solomon url', default='http://solomon.yandex-team.ru')
        checkouter_url = sdk2.parameters.String('Checkouter url', default='http://checkouter.tst.vs.market.yandex.net:39001')
        application_path = sdk2.parameters.String('Application path', default='/tasks/health/solomon')
        project_id = sdk2.parameters.String('Project id', default='market-checkouter-devel')
        dashboard_id = sdk2.parameters.String('Dashboard id', default='market-checkouter-tasks-alerts')
        annotation_keys = sdk2.parameters.String('Annotation keys', default='taskName')
        oauth_token_vault_key = sdk2.parameters.String('Oauth token vault key', default='market_checkouter_solomon_oauth_token')
        row_size = sdk2.parameters.Integer('Row size', default=4)
        height_multiplier=sdk2.parameters.Integer('Height multiplier', default=1)
        annotation_key_filter=sdk2.parameters.String('Annotation key filter (json dictionary)', default='{}')

    def on_execute(self):
        oauth_token = sdk2.Vault.data('MARKET', self.Parameters.oauth_token_vault_key)

        solomon = Solomon(
            oauthToken=oauth_token,
            solomonUrl=self.Parameters.solomon_api_url
        )

        generator = dashboard.DashboardGenerator(
            checkouter_url=self.Parameters.checkouter_url,
            application_path=self.Parameters.application_path,
            project_id=self.Parameters.project_id,
            annotation_keys=self.Parameters.annotation_keys,
            solomon=solomon,
            dashboard_id=self.Parameters.dashboard_id,
            solomon_url=self.Parameters.solomon_url,
            row_size=self.Parameters.row_size,
            annotation_key_filter=json.loads(self.Parameters.annotation_key_filter),
            height_multiplier=self.Parameters.height_multiplier
        )
        result = generator.generate()
        generator.update_dashboard(result)
