import generate
import wiki

from sandbox import sdk2
from sandbox.sandboxsdk import environments

class MarketCheckouterGenerateDatabaseDoc(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = (environments.PipEnvironment('psycopg2-binary'),)


    class Parameters(sdk2.Task.Parameters):
        host = sdk2.parameters.String('Database host', default='market-checkouter-test01f.db.yandex.net,market-checkouter-test01i.db.yandex.net,market-checkouter-test01h.db.yandex.net')
        port = sdk2.parameters.String('Database port', default='6432,6432,6432')
        dbname = sdk2.parameters.String('Database name', default='market_checkouter_test')
        user = sdk2.parameters.String('Database username', default='market_checkouter')

        wiki_root_url = sdk2.parameters.String('Wiki root path', default='/users/timursha/database-auto')
        grid_template = sdk2.parameters.String('Grid template', default='/users/timursha/autogen/table')
        indexes_root_url = sdk2.parameters.String('Indexes root path', default='/users/timursha/indexes-auto')
        indexes_grid_template = sdk2.parameters.String('Indexes grid template', default='/users/timursha/autogen/index')
        pages_root_url = sdk2.parameters.String('Pages root path', default='/users/timursha/autogen/database')
        foreign_keys_root_url = sdk2.parameters.String('Foreign keys root path', default='/users/timursha/foreign-keys-auto')
        foreign_keys_grid_template = sdk2.parameters.String('Foreign keys grid template', default='/users/timursha/autogen/foreign_key')

        vault_owner = sdk2.parameters.String('Vault oauth token owner', default='MARKET')


    def on_execute(self):
        oauth_token = sdk2.Vault.data(self.Parameters.vault_owner, 'market_checkouter_wiki_oauth_token')
        database_password = sdk2.Vault.data(self.Parameters.vault_owner, 'market_checkouter_test_database_password')

        wiki_api = wiki.WikiApi('https://wiki-api.yandex-team.ru/_api', oauth_token)

        generateDatabaseDoc = generate.GenerateDatabaseDoc(
            self.Parameters.host,
            self.Parameters.port,
            self.Parameters.dbname,
            self.Parameters.user,
            database_password,
            self.Parameters.wiki_root_url,
            wiki_api,
            self.Parameters.grid_template,
            self.Parameters.indexes_root_url,
            self.Parameters.indexes_grid_template,
            self.Parameters.pages_root_url,
            self.Parameters.foreign_keys_root_url,
            self.Parameters.foreign_keys_grid_template,
            True
        )
        generateDatabaseDoc.generate()
        generateDatabaseDoc.generate_indexes()
        generateDatabaseDoc.generate_pages()
        generateDatabaseDoc.generate_foreign_keys()
