import alerts

from sandbox import sdk2

class MarketCheckouterGenerateHttpAlerts(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        solomon_url = sdk2.parameters.String('Solomon api url', default='http://solomon.yandex.net/api/v2/projects')
        checkouter_url = sdk2.parameters.String('Checkouter url', default='http://checkouter.tst.vs.market.yandex.net:39001/monitor/dev/groups')
        project_id = sdk2.parameters.String('Project id', default='market-checkouter-devel')
        oauth_token_vault_key = sdk2.parameters.String('Oauth token vault key', default='market_checkouter_solomon_oauth_token')
        period_millis = sdk2.parameters.Integer('Period millis', default = 300000)
        delay_seconds = sdk2.parameters.Integer('Delay seconds', default = 120)
        group_black_list = sdk2.parameters.String('Group blacklist separated by comma', default='')
        channels_list = sdk2.parameters.String('Alert channels list separated by comma', default='telegram')
        payment_channels_list = sdk2.parameters.String('Payment alert channels list separated by comma', default='telegram_market_payment_alerts')
        tasks_for_payment_alerts_list = sdk2.parameters.String('Tasks for payment alert channels list separated by comma', default='stuck-refunds-checker')

    def on_execute(self):
        solomon_project_url = self.Parameters.solomon_url + '/' + self.Parameters.project_id
        oauth_token = sdk2.Vault.data('MARKET', self.Parameters.oauth_token_vault_key)
        group_black_list = set(self.Parameters.group_black_list.split(','))
        channels_list = self.Parameters.channels_list.split(',')
        tasks_for_payment_alerts_list = self.Parameters.tasks_for_payment_alerts_list.split(',')
        payment_channels_list = self.Parameters.payment_channels_list.split(',')

        generator = alerts.Generator(
            oauth_token,
            solomon_project_url,
            self.Parameters.project_id,
            self.Parameters.checkouter_url,
            group_black_list,
            channels_list,
            payment_channels_list,
            tasks_for_payment_alerts_list,
            periodMillis=self.Parameters.period_millis,
            delaySeconds=self.Parameters.delay_seconds
        )
        generator.generate()
