import dashboard

from sandbox import sdk2
from sandbox.projects.market.checkout.helpers.solomon import Solomon


class MarketCheckouterGenerateHttpAlertsDashboard(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        solomon_api_url = sdk2.parameters.String('Solomon api url', default='http://solomon.yandex.net')
        solomon_url = sdk2.parameters.String('Solomon url', default='https://solomon.yandex-team.ru')
        checkouter_url = sdk2.parameters.String('Checkouter url', default='http://checkouter.tst.vs.market.yandex.net:39001')
        project_id = sdk2.parameters.String('Project id', default='market-checkouter-devel')
        dashboard_id = sdk2.parameters.String('Dashboard id', default='market-checkouter-http-alerts')
        oauth_token_vault_key = sdk2.parameters.String('Oauth token vault key', default='market_checkouter_solomon_oauth_token')
        row_size = sdk2.parameters.Integer('Row size', default=4)

    def on_execute(self):
        oauth_token = sdk2.Vault.data('MARKET', self.Parameters.oauth_token_vault_key)

        solomon = Solomon(
            oauthToken=oauth_token,
            solomonUrl=self.Parameters.solomon_api_url
        )

        generator = dashboard.DashboardGenerator(
            checkouterUrl=self.Parameters.checkouter_url,
            solomonUrl=self.Parameters.solomon_url,
            solomon=solomon,
            projectId=self.Parameters.project_id,
            dashboardId=self.Parameters.dashboard_id,
            rowSize=self.Parameters.row_size
        )
        result = generator.generate()
        generator.replace_dashboard(result)
