import logging
import os
import requests


class DashboardGenerator():
    def __init__(self,
                 checkouterUrl,
                 solomon,
                 solomonUrl='https://solomon.yandex-team.ru',
                 projectId='market-checkouter-devel',
                 dashboardId='market-checkouter-http-alerts',
                 rowSize=5):
        self.checkouterUrl = checkouterUrl
        self.projectId = projectId
        self.dashboardId = dashboardId
        self.rowSize = rowSize
        self.solomonUrl = solomonUrl
        self.solomon = solomon

    def generate(self):
        elements = self.generate_elements()

        rows = []
        row = {
            "panels": []
        }
        for element in elements:
            row['panels'].append({
                "type": "IFRAME",
                "url": element['url'],
                "title": ""
            })

            if len(row['panels']) == self.rowSize:
                rows.append(row)
                row = {
                    "panels": []
                }

        rows.append(row)

        return rows

    def replace_dashboard(self, content):
        dashboard = self.solomon.get_dashboard(self.projectId, self.dashboardId)

        body = {
            "name": self.dashboardId,
            "heightMultiplier": 1,
            "rows": content
        }

        if dashboard is None:
            body['version'] = 0
            self.solomon.create_dashboard(self.projectId, self.dashboardId, body)
        else:
            body['version'] = dashboard['version']
            self.solomon.update_dashboard(self.projectId, self.dashboardId, body)

    def generate_elements(self):
        groups = requests.get(self.checkouterUrl + '/monitor/dev/groups').json()
        groups.sort(key=lambda g: g['groupName'])

        elements = []
        for group in groups:
            elements.append({
                "url": self.solomonUrl + "/admin/projects/market-checkouter-devel/alerts/{alertid}/singlestat/fullscreen?annotationKeys=group_name".format(
                    alertid='c-h-m-' + group['groupName']
                ),
                "title": ""
            })

        return elements


def main():
    import os,sys
    currentdir = os.path.dirname(os.path.abspath(__file__))
    parentdir = os.path.dirname(currentdir)
    sys.path.insert(0,parentdir) 

    from helpers.solomon import Solomon

    logging.basicConfig(level=logging.DEBUG)

    oauthToken = os.environ['SOLOMON_OAUTH']

    solomon_instance = Solomon(
        solomonUrl='https://solomon.yandex-team.ru',
        oauthToken=oauthToken
    )

    generator = DashboardGenerator(
        checkouterUrl='http://checkouter.tst.vs.market.yandex.net:39001',
        solomon=solomon_instance,
        solomonUrl='https://solomon.yandex-team.ru',
        rowSize=4
    )

    result = generator.generate()
    print result

    generator.replace_dashboard(result)

if __name__ == '__main__':
    main()
