from sandbox import sdk2

import alerts


class MarketCheckouterGenerateQueuedCallsAlerts(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        solomon_url = sdk2.parameters.String('Solomon api url', default='http://solomon.yandex.net/api/v2/projects')
        checkouter_url = sdk2.parameters.String('Checkouter url',
                                                default='http://checkouter.tst.vs.market.yandex.net:39001/monitor/dev/groups')
        project_id = sdk2.parameters.String('Project id', default='market-checkouter-devel')
        oauth_token_vault_key = sdk2.parameters.String('Oauth token vault key',
                                                       default='market_checkouter_solomon_oauth_token')
        channels = sdk2.parameters.String('Notification channels separated by comma', default='telegram')
        payment_channels = sdk2.parameters.String('Payment notification channels separated by comma',
                                                  default='telegram_market_payment_alerts')
        tasks_for_payment_alerts = sdk2.parameters.String('Tasks for payment alert channels list separated by comma',
                                                          default='ORDER_CREATE_OFFSET_ADVANCE_RECEIPT')
        period_millis = sdk2.parameters.Integer('Period millis', default=300000)
        delay_seconds = sdk2.parameters.Integer('Delay seconds', default=120)

    def on_execute(self):
        solomon_project_url = self.Parameters.solomon_url + '/' + self.Parameters.project_id
        channels_list = self.Parameters.channels.split(',')
        payment_channels_list = self.Parameters.payment_channels.split(',')
        oauth_token = sdk2.Vault.data('MARKET', self.Parameters.oauth_token_vault_key)

        generator = alerts.Generator(
            oauth_token,
            solomon_project_url,
            self.Parameters.project_id,
            self.Parameters.checkouter_url,
            channels_list,
            payment_channels_list,
            self.Parameters.period_millis,
            self.Parameters.delay_seconds
        )
        generator.generate()
