# coding=utf-8
import entity
import enums
import logging
import headers
import params
from collections import OrderedDict
from sandbox import sdk2
from utils import requests_retry_session

class MarketCheckouterGenerateWiki(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        wiki_url = sdk2.parameters.String('Wiki api url', default='https://wiki-api.yandex-team.ru/_api')
        url = sdk2.parameters.String('Checkouter api url', default='http://gravicapa01ht.market.yandex.net:39001/v2/api-docs')
        root_page = sdk2.parameters.String('Root page', default=u'/users/timursha/autogen')
        params_root_page = sdk2.parameters.String('Params root page', default=u'/users/timursha/autogen-params')
        headers_root_page = sdk2.parameters.String('Headers root page', default=u'/users/timursha/autogen-headers')
        vault_owner = sdk2.parameters.String('Vault oauth token owner', default='MARKET')

    def on_execute(self):
        WIKI_URL = self.Parameters.wiki_url
        url = self.Parameters.url
        ROOT_PAGE = self.Parameters.root_page
        PARAMS_ROOT_PAGE = self.Parameters.params_root_page
        HEADERS_ROOT_PAGE = self.Parameters.headers_root_page
        OAUTH_TOKEN = sdk2.Vault.data(self.Parameters.vault_owner, 'market_checkouter_wiki_oauth_token')
        GRID_TEMPLATE = '/users/timursha/autogen/grid'

        print('wiki_url = {}, url = {}, root_page = {}'.format(WIKI_URL, url, ROOT_PAGE))

        logging.info('loading swagger definition')

        resp = requests_retry_session().get(url, headers={"IgnoreTvmCheck": "true"})
        logging.info("Swagger answers with code: {}".format(resp.status_code))

        swagger = resp.json(object_pairs_hook=OrderedDict)

        logging.info('processings enums')

        enumBuilder = enums.EnumBuilder(OAUTH_TOKEN, wiki_url=WIKI_URL, root_page=ROOT_PAGE)
        enumBuilder.process_enums(swagger)

        logging.info('processings entities')

        entityBuilder = entity.EntityBuilder(OAUTH_TOKEN, WIKI_URL, ROOT_PAGE)
        entityBuilder.process_definitions(swagger)

        logging.info('processings params')

        builder = params.ParamsBuilder(OAUTH_TOKEN, WIKI_URL, PARAMS_ROOT_PAGE, GRID_TEMPLATE, ROOT_PAGE)
        builder.process_definition(swagger)

        logging.info('processings headers')

        headersBuilder = headers.HeadersBuilder(OAUTH_TOKEN,  WIKI_URL, HEADERS_ROOT_PAGE, GRID_TEMPLATE, ROOT_PAGE)
        headersBuilder.process_definition(swagger)
