# coding=utf-8

import requests
from requests.adapters import HTTPAdapter
from urllib3.util.retry import Retry


def match_simple_type(property_type):
    if property_type == 'boolean':
        return u'Булев'
    elif property_type == 'string':
        return u'Строка'
    elif property_type == 'integer':
        return u'Целое'
    elif property_type == 'number':
        return u'Дробное'
    elif property_type == 'object':
        return u'Объект'
    else:
        return ''


def match_type(property_definition):
    if 'type' in property_definition:
        property_type = property_definition['type']

        if property_type != 'array':
            return (match_simple_type(property_type), False)
        else:
            item_type = property_definition['items']
            return (match_type(item_type)[0], True)
    elif '$ref' in property_definition:
        # TODO: ссылка на объект
        return (u'Объект', False)
    else:
        return (None, False)


def escape_entity(entity):
    return entity.replace(u"«", "_").replace(u"»", "").replace(",", "_")


def get_property_format(property_definition, root_page=''):
    if "example" in property_definition:
        return property_definition["example"]

    if "$ref" in property_definition:
        ref = property_definition['$ref']
    elif "enumClass" in property_definition:
        ref = property_definition["enumClass"]
    elif "type" in property_definition and property_definition['type'] == "array" and "$ref" in property_definition['items']:
        ref = property_definition['items']['$ref']
    else:
        ref = None

    if ref is not None:
        return u"(({root_page}{entity} {entity}))".format(
            entity=escape_entity(ref.replace('#/definitions/', '')),
            root_page=root_page + '/' if root_page else ''
        )
    else:
        return ''


def requests_retry_session(retries=5, backoff_factor=0.3, status_forcelist=(500, 502, 504), session=None):
    retry = Retry(
        total=retries,
        read=retries,
        connect=retries,
        backoff_factor=backoff_factor,
        status_forcelist=status_forcelist
    )

    adapter = HTTPAdapter(max_retries=retry)
    session = session or requests.Session()
    session.mount('http://', adapter)
    session.mount('https://', adapter)

    return session


if __name__ == "__main__":
    url = "http://checkouter.tst.vs.market.yandex.net:39001/v2/api-docs"
    resp = requests_retry_session().get(url, headers={"IgnoreTvmCheck": "true"})
    print("Swagger answers with code: {}".format(resp.status_code))
    from collections import OrderedDict
    swagger = resp.json(object_pairs_hook=OrderedDict)
