USE marketclickhouse;

SELECT http_method as http_method,
       method as method,
       case
           when kv_values[indexOf(kv_keys, 'param.archived')] is null or kv_values[indexOf(kv_keys, 'param.archived')] = ''
               then 'false'
           else kv_values[indexOf(kv_keys, 'param.archived')]
       end as archived,
       case when method in ('cart', 'checkout') then sum(length(splitByChar(',', kv_values[indexOf(kv_keys, 'warehouseIds')]))) else count() end / (11 * 60 * 60) as rps
FROM market.checkouter
WHERE date = today() - 1
AND NOT (url LIKE '/monitor%' OR url LIKE '/ping' OR url LIKE '/queuedcalls%')
AND kv_values[indexOf(kv_keys, 'param.uid')] != '2308324861409815965'
AND NOT (toInt64OrZero(kv_values[indexOf(kv_keys, 'param.uid')]) BETWEEN 2190550858753437195 AND 2190550859753437194)
AND marketEnvironmentProfile = 'standard'
AND toHour(toDateTime(timestamp)) BETWEEN 12 AND 22
GROUP BY http_method, method, archived
ORDER BY rps DESC
;
