# -*- coding: utf8 -*-

from sandbox.projects.market.checkout.resources import CheckouterLoadAmmo
from sandbox.projects.market.checkout.resources import CheckouterLoadConfig
from sandbox.projects.market.checkout.helpers.get_offer import get_offer
from sandbox.projects.market.checkout.helpers.get_delivery_id import get_delivery_id
from sandbox import sdk2
from generate import (
    cart,
    multicart_actualize,
    checkout,
    actualize,
    order_events,
    orders_by_id,
    orders_by_uid,
)

import codecs
import random

class MarketCheckoutLoadGenerateAmmo(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        test_duration_minutes = sdk2.parameters.Integer('Test duration minutes', default=10)
        total_rps = sdk2.parameters.Float('Total rps', default= 5)

        checkouter_url = sdk2.parameters.String('Checkouter url', default='http://checkouter.load.vs.market.yandex.net:39001')
        report_url = sdk2.parameters.String('Report url', default='http://report.tst.vs.market.yandex.net:17051')
        stocks_url = sdk2.parameters.String('Stocks url', default='https://bos.tst.vs.market.yandex.net/stocks')
        loyalty_url = sdk2.parameters.String('Loyalty url', default='http://market-loyalty.tst.vs.market.yandex.net:35815')

        available_promocodes = sdk2.parameters.String('Available promocodes', default='COUPON_FOR_LOAD2,COUPON_FOR_LOAD,COUPON_FOR_LOAD3')
        shop_id = sdk2.parameters.Integer('Shop id', default=431782)
        coins_promo_id = sdk2.parameters.Integer('Coins promo id', default=10432)
        last_event_id_range = sdk2.parameters.Integer('Max eventId for last event id query', default=119000000)
        datafeed_id = sdk2.parameters.Integer('Datafeed id', default=200344277)

        delivery_type = sdk2.parameters.String('delivery_type', default='DELIVERY')
        coins_disabled = sdk2.parameters.Bool('Coins disabled', default_value=False)

    def on_execute(self):
        total_requests = int(self.Parameters.test_duration_minutes * 60 * self.Parameters.total_rps)
        ammo = []

        services = self.get_services()
        options = self.get_options()

        sum_rps = reduce(lambda x, y: x + y, map(lambda s : s.rps, services))
        for service in services:
            request_count = int(service.rps / sum_rps * total_requests)
            ammo.extend(service.ammo_generating_function(options, request_count))

        random.shuffle(ammo)

        data = sdk2.ResourceData(CheckouterLoadAmmo(self, 'Checkouter load ammo', 'ammo.txt'))
        with codecs.open('ammo.txt', 'w', encoding='utf-8') as f:
            f.writelines(ammo)
        data.ready()

        data2 = sdk2.ResourceData(CheckouterLoadConfig(self, 'Checkouter load config', 'check.ini'))
        with codecs.open('check.ini', 'w', encoding='utf-8') as f:
            f.writelines('''
[meta]
task=MARKETCHECKOUT-5846
api_address=https://lunapark.yandex-team.ru/
job_name=MARKETCHECKOUT-5846
operator=timursha

[tank]
plugin_phantom=yandextank.plugins.Phantom
plugin_uploader=yandextank.plugin.DataUploader meta
plugin_monitoring=

[phantom]
rps_schedule=const({}, {}m)
timeout=30s
'''.format(self.Parameters.total_rps, self.Parameters.test_duration_minutes))
        data2.ready()

    def get_services(self):
        return [
            ServiceToTest("cart", cart, 1.673611111111111),
            ServiceToTest("multicart_actualize", multicart_actualize, 1.673611111111111),
            ServiceToTest("checkout", checkout, 0.18819444444444444),
            ServiceToTest("actualize", actualize, 1.1270833333333332),
            ServiceToTest("orders_by_uid", orders_by_uid, 1.1104166666666666),
            ServiceToTest("order_events", order_events, 3.5),
            ServiceToTest("orders_by_id", orders_by_id, 0.21)
        ]

    def get_options(self):
        available_users = xrange(0, 500000)

        offer = get_offer(self.Parameters.report_url, self.Parameters.shop_id, self.Parameters.datafeed_id)
        feed_id = offer['shop']['feed']['id']
        offer_id = offer['shop']['feed']['offerId']
        fee_show = offer['feeShow']

        delivery_id, outlet = get_delivery_id(self.Parameters.checkouter_url, random.choice(available_users), self.Parameters.shop_id, feed_id, offer_id, fee_show, self.Parameters.delivery_type)
        return {
            'available_users': available_users,
            'available_orders': xrange(0, 1000000),
            'available_promocodes': self.Parameters.available_promocodes.split(','),

            'report_url': self.Parameters.report_url,
            'stocks_url': self.Parameters.stocks_url,
            'loyalty_url': self.Parameters.loyalty_url,

            'coins_promo_id': self.Parameters.coins_promo_id,
            'shop_id': self.Parameters.shop_id,
            'last_event_id_range': xrange(self.Parameters.last_event_id_range, self.Parameters.last_event_id_range + 300000),

            'feed_id': feed_id,
            'offer_id': offer_id,
            'fee_show': fee_show,
            'supplier_id': offer['supplier']['id'],
            'shop_sku': offer['shopSku'],
            'offer_price': offer['prices']['value'],
            'warehouse_id': offer['supplier']['warehouseId'],
            'delivery_id': delivery_id,
            'outlet': outlet,
            'coins_disabled': self.Parameters.coins_disabled
        }


class ServiceToTest():
    def __init__(self, name, ammo_generating_function, rps):
        self.name = name
        self.rps = rps
        self.ammo_generating_function = ammo_generating_function

