# coding=utf-8
# util method for generating ammo
import logging
import random
import requests
import string

def make_ammo(method, url, tag, headers='Host: gravicapa01ht.market.yandex.net', body=None):
    """
        Makes phantom ammo
        http://yandextank.readthedocs.org/en/latest/ammo_generators.html
    """

    # http request w/o entity body template
    req_template = (
        "%s %s HTTP/1.1\r\n"
        "%s\r\n"
        "\r\n"
    )

    # http request with entity body template
    req_template_w_entity_body = (
        "%s %s HTTP/1.1\r\n"
        "%s\r\n"
        "Content-Type: application/json\r\n"
        "Content-Length: %d\r\n"
        "\r\n"
        "%s\r\n"
    )

    if not body:
        req = req_template % (method, url, headers)
    else:
        req = req_template_w_entity_body % (method, url, headers, len(body.encode('utf-8')), body)

    # phantom ammo template
    ammo_template = (
        "%d %s\n"
        "%s"
    )

    return ammo_template % (len(req.encode('utf-8')), tag, req)


def orders_by_uid(options, count):
    result = []
    for i in xrange(count):
        user_id = random.choice(options['available_users'])
        result.append(make_ammo("GET", "/orders/by-uid/{}".format(user_id), "orders_by_uid"))
    return result


def make_coins(options, uid, count):
    req = '{0}/dontUseInProduction/createCoinForLoad?promoId={1}&uid={2}'.format(
        options['loyalty_url'], options['coins_promo_id'], uid)
    headers = {'Content-Type': 'application/json'}

    coins = []
    for x in range(0, count):
        try:
            loyalty_answ = requests.post(req, headers=headers)
            if loyalty_answ.status_code != 200:
                logging.error('Loyalty answer status code is %d, expected: 200', loyalty_answ.status_code)
                raise Exception()

            coins.append(loyalty_answ.json()['id'])
        except Exception as exc:
            logging.exception(
                'Exception trying to create coins: %s. Url %s', exc, req)
            raise exc

    return coins


def cart(options, count):
    cart_count = int(0.4 * count) + 1
    result = []
    coins_enabled = options.get('coins_disabled') != True
    for i in xrange(cart_count):
        result.append(cart_internal(options, random.choice(options['available_users']), None, None))

    if coins_enabled == True:
        cart_coupon_count = int(0.1 * count) + 1
        for i in xrange(cart_coupon_count):
            result.append(cart_internal(options, random.choice(options['available_users']), None,
                                  random.choice(options['available_promocodes'])))

        cart_coins_count = int(0.3 * count) + 1
        for i in xrange(cart_coins_count):
            uid = random.choice(options['available_users'])
            result.append(cart_internal(options, uid, make_coins(options, uid, random.randint(1, 3)), None))

        cart_coins_coupon_count = int(0.2 * count) + 1
        for i in xrange(cart_coins_coupon_count):
            uid = random.choice(options['available_users'])
            result.append(cart_internal(options, uid, make_coins(options, uid, random.randint(1, 3)),
                                  random.choice(options['available_promocodes'])))
    return result


def cart_internal(options, uid, coins, promo):
    headers = "X-Hit-Rate-Group: UNLIMIT\r\nHost: gravicapa01ht.market.yandex.net"

    promo_code_line = '"promocode": "' + promo + '",' if promo is not None else ''
    coins_line = '"coinIdsToUse": [' + ','.join(map(str, coins)) + '],' if coins is not None else ''
    tag = "cart"
    if coins is not None:
        tag = tag + '_coins'
    if promo is not None:
        tag = tag + '_coupon'

    payload = u'''{
    "buyerRegionId": %d,
    %s
    "buyerCurrency": "RUR",
    "carts": [
        {
            "shopId": %s,
            %s
            "items": [
                {
                    "feedId": %s,
                    "offerId": "%s",
                    "showInfo": "%s",
                    "count": 1
                }
            ],
            "delivery" : {
                "regionId" : %d,
                "address" : {
                    "country" : "Россия",
                    "postcode" : "119313",
                    "city" : "Санкт-Петербург",
                    "subway" : "Проспект Вернадского",
                    "street" : "Ленинский проспект",
                    "house" : "90",
                    "floor" : "6"
                }
            }
        }
    ]
}''' % (213, promo_code_line, options['shop_id'], coins_line, options['feed_id'], options['offer_id'], options['fee_show'], 213)

    return make_ammo('POST', '/cart?rgb=BLUE&minifyOutlets=true&uid={}'.format(uid),
                     tag,
                     headers=headers, body=payload)

def multicart_actualize(options, count):
    cart_count = int(0.4 * count) + 1
    result = []
    coins_enabled = options.get('coins_disabled') != True
    for i in xrange(cart_count):
        uid = random.choice(options['available_users'])
        result.append(multicart_actualize_internal(options, uid, None))

    if coins_enabled == True:
        cart_coins_count = int(0.3 * count) + 1
        for i in xrange(cart_coins_count):
            uid = random.choice(options['available_users'])
            coins = make_coins(options, uid, random.randint(1, 3))
            result.append(multicart_actualize_internal(options, uid, coins))

    return result

def multicart_actualize_internal(options, uid, coins):
    headers = "X-Hit-Rate-Group: UNLIMIT\r\nHost: gravicapa01ht.market.yandex.net"
    coins_line = '"coinIdsToUse": [' + ','.join(map(str, coins)) + '],' if coins is not None else ''
    tag = "multicart_actualize"
    if coins is not None:
        tag = tag + '_coins'
    payload = u'''{
    "buyer": {
        "userId": %d,
        "regionId": %d,
        "currency": "RUR"
    },
    %s
    "carts": [{
        "label": "cart-1",
        "shopId": %s,
        "items": [{
            "label": "item-1",
            "feedId": %s,
            "offerId": "%s",
            "buyerPrice": "%s",
            "count": 1
        }]
    }]
    }
    ''' % (
        uid,
        213,
        coins_line,
        options['shop_id'],
        options['feed_id'],
        options['offer_id'],
        options['offer_price']
    )
    return make_ammo('POST', '/v2/multicart/actualize?rgb=BLUE', tag, headers=headers, body=payload)


def checkout(options, count):
    checkout_coupon_count = int(0.1 * count) + 1
    result = []
    for i in xrange(checkout_coupon_count):
        result.append(checkout_internal(options, random.choice(options['available_users']), None,
                                  random.choice(options['available_promocodes'])))

    checkout_coins_count = int(0.3 * count) + 1
    for i in xrange(checkout_coins_count):
        uid = random.choice(options['available_users'])
        result.append(checkout_internal(options, uid, make_coins(options, uid, random.randint(1, 3)), None))

    checkout_coins_coupon_count = int(0.2 * count) + 1
    for i in xrange(checkout_coins_coupon_count):
        uid = random.choice(options['available_users'])
        result.append(checkout_internal(options, uid, make_coins(options, uid, random.randint(1, 3)),
                                  random.choice(options['available_promocodes'])))

    checkout_count = int(0.4 * count) + 1
    for i in xrange(checkout_count):
        result.append(checkout_internal(options, random.choice(options['available_users']), None, None))
    return result


def checkout_internal(options, uid, coins, promo):
    headers = "X-Hit-Rate-Group: UNLIMIT\r\nHost: gravicapa01ht.market.yandex.net"
    promo_code_line = '"promocode": "' + promo + '",' if promo is not None else ''
    coins_line = '"coinIdsToUse": [' + ','.join(map(str, coins)) + '],' if coins is not None else ''

    tag = "checkout"
    if coins is not None:
        tag = tag + '_coins'
    if promo is not None:
        tag = tag + '_coupon'

    payload = u'''
    {
        "buyerRegionId": %s,
        "buyerCurrency": "RUR",
        "paymentType": "POSTPAID",
        %s
        "paymentMethod": "CASH_ON_DELIVERY",
        "orders": [
            {
                "shopId": %s,
                %s
                "items": [
                    {
                        "feedId": %s,
                        "offerId": "%s",
                        "showInfo": "%s",
                        "buyerPrice": %s,
                        "count": 1
                    }
                ],
                "delivery": {
                    "id": "%s",
                    "regionId": %s,
                    %s
                },
                "notes": "заметочка"
            }
        ],
        "buyer": {
            "lastName": "последнееимя",
            "firstName": "первоеимя",
            "middleName": "среднееимя",
            "phone": "%s",
            "email": "%s",
            "ip": "8.8.8.8"
        }
    }
    ''' % (
        '213',
        promo_code_line,
        options['shop_id'],
        coins_line,
        options['feed_id'],
        options['offer_id'],
        options['fee_show'],
        options['offer_price'],
        options['delivery_id'],
        '213',
        options['outlet'],
        random_phone(),
        random_email()
    )

    return make_ammo('POST', '/checkout?rgb=BLUE&uid={}&minifyOutlets=true'.format(uid), tag,
                     headers=headers, body=payload)


def actualize(options, count):
    headers = "X-Hit-Rate-Group: UNLIMIT\r\nHost: gravicapa01ht.market.yandex.net"

    result = []
    for i in xrange(count):
        payload = u'''{
            "buyerRegionId": 213,
            "shopId": %s,
            "feedId": %s,
            "offerId": "%s"
        }''' % (options['shop_id'], options['feed_id'], options['offer_id'])

        result.append(make_ammo('POST',
                          '/actualize?rgb=BLUE&minifyOutlets=true&uid={}'.format(
                              random.choice(options['available_users'])),
                          'actualize', headers=headers, body=payload))
    return result


def order_events(options, count):
    result = []
    for i in xrange(count):
        last_event_id = random.choice(options['last_event_id_range'])
        result.append(make_ammo("GET",
                          "/orders/events?lastEventId={}&batchSize=50&rgb=WHITE&rgb=BLUE".format(
                              last_event_id),
                          "orders_events"))
    return result


def orders_by_id(options, count):
    result = []
    for i in xrange(count):
        order_id = random.choice(options['available_orders'])
        result.append(make_ammo("GET", "/orders/{}?clientRole=SYSTEM".format(order_id), "orders_by_id"))
    return result

def random_email():
    return ''.join(random.sample(string.lowercase, 10)) + '@' + ''.join(random.sample(string.lowercase, 10)) + '.ru'

def random_phone():
    return "+7" + ''.join(random.sample('0123456789', 10))
