import logging as log


class DataBase:
    def __init__(self, db_password, db_name, username, hostname):
        self.db_password = db_password
        self.db_name = db_name
        self.username = username
        self.hostname = hostname

    def fetch_order_ids(self):
        return map(lambda r: r[0], self.__fetchall('''select id from orders order by id desc limit 10000'''))

    def fetch_processing_order_ids(self):
        return map(lambda r: r[0], self.__fetchall('''select id from orders where status = 3 limit 10000'''))

    def fetch_existing_user_ids(self):
        return map(lambda r: r[0], self.__fetchall('''select distinct user_id from orders limit 10000'''))

    def fetch_order_ids_receipt_ids(self):
        return self.__fetchall('''select distinct o.id order_id, r.id receipt_id from receipt r
                                    join orders o on r.payment_id = o.payment_id
                                    where pdf_url is not null
                                    order by r.id desc limit 10000''')

    def fetch_order_ids_with_payment(self):
        return map(lambda r: r[0], self.__fetchall('''select id from orders where payment_id is not null
                                                      order by id desc limit 10000'''))

    def fetch_payment_ids(self):
        return map(lambda r: r[0], self.__fetchall('''select distinct payment_id from orders
                                    where payment_id is not null
                                    order by payment_id desc limit 10000'''))

    def __fetchall(self, sql):
        with self.__new_connection() as conn:
            log.debug('Executing SQL: {}'.format(sql))
            cursor = conn.cursor()
            cursor.execute(sql)
            data = cursor.fetchall()
            log.debug('Fetched {} rows from DB'.format(len(data)))
            return data

    def __new_connection(self):
        import psycopg2
        return psycopg2.connect(dbname=self.db_name,
                                user=self.username,
                                password=self.db_password,
                                host=self.hostname, port=6432)


if __name__ == '__main__':
    db = DataBase('<password>')
    import random

    processing_ids = db.fetch_processing_order_ids()
    print(random.choice(db.fetch_processing_order_ids()))
    print(len(processing_ids))
