# coding=utf-8
# util method for generating ammo
import logging
import random
import string
import time

import requests

HIT_RATE_UNLIMIT_HEADER = "X-Hit-Rate-Group: UNLIMIT\r\nHost: gravicapa01ht.market.yandex.net"


def make_ammo(method, url, tag, headers=None, body=None):
    if headers is None:
        headers = HIT_RATE_UNLIMIT_HEADER
    else:
        headers = headers + "\r\n" + HIT_RATE_UNLIMIT_HEADER

    """
        Makes phantom ammo
        http://yandextank.readthedocs.org/en/latest/ammo_generators.html
    """

    # http request w/o entity body template
    req_template = (
        "%s %s HTTP/1.1\r\n"
        "%s\r\n"
        "\r\n"
    )

    # http request with entity body template
    req_template_w_entity_body = (
        "%s %s HTTP/1.1\r\n"
        "%s\r\n"
        "Content-Type: application/json\r\n"
        "Content-Length: %d\r\n"
        "\r\n"
        "%s\r\n"
    )

    if not body:
        req = req_template % (method, url, headers)
    else:
        req = req_template_w_entity_body % (method, url, headers, len(body.encode('utf-8')), body)

    # phantom ammo template
    ammo_template = (
        "%d %s\n"
        "%s"
    )

    return ammo_template % (len(req.encode('utf-8')), tag, req)


# GET orders_by-uid_userId
def orders_by_uid(options, count, archived='false', sort='BY_DATE', headers=None):
    result = []

    if archived == 'true':
        existing_users = options['archived_existing_users']
    else:
        existing_users = options['existing_users']

    for i in xrange(count):
        result.append(make_ammo("GET",
                                "/orders/by-uid/{}?archived={}&rgb=BLUE&sort={}".format(
                                    random.choice(existing_users), archived, sort),
                                "GET_orders_by-uid_userId_archived_" + archived, headers))
    return result


def orders_by_uid_sort_by_importance(options, count, archived='false'):
    return orders_by_uid(options, count, archived, "BY_IMPORTANCE",
                         "X-Market-Rearrfactors: user_orders_sorting_by_importance=1")


def orders_by_uid_recent(options, count, sort='BY_DATE', headers=None):
    result = []
    for i in xrange(count):
        user_id = random.choice(options['existing_users'])
        result.append(make_ammo("GET", "/orders/by-uid/{}/recent?sort={}&".format(user_id, sort) +
                                "status=UNPAID&status=PROCESSING&status=DELIVERY&status=PICKUP&status=PENDING&"
                                "pageSize=5&rgb=BLUE&"
                                "partials=ITEMS&partials=DELIVERY", "GET_orders_by-uid_userId_recent", headers))
    return result


def orders_by_uid_recent_sort_by_importance(options, count):
    return orders_by_uid_recent(options, count, "BY_IMPORTANCE",
                                "X-Market-Rearrfactors: user_orders_sorting_by_importance=1")


def get_orders_user(options, count, archived='false'):
    result = []
    if archived == 'true':
        existing_users = options['archived_existing_users']
    else:
        existing_users = options['existing_users']

    for i in xrange(count):
        payload = u'''{
            "rgbs": ["BLUE", "WHITE"]
        }'''

        result.append(make_ammo('POST',
                                '/get-orders?clientRole=USER&clientId={}&archived={}'.format(
                                    random.choice(existing_users), archived),
                                'POST_get-orders_archived_' + archived, body=payload))
    return result


def make_coins(options, uid, count):
    logging.info('creating coin')
    req = '{0}/dontUseInProduction/createCoinForLoad?promoId={1}&uid={2}'.format(
        options['loyalty_url'], options['coins_promo_id'], uid)
    headers = {'Content-Type': 'application/json'}

    coins = []
    for x in range(0, count):
        retries_left = 10
        try:
            while True:
                retries_left -= 1
                loyalty_answ = requests.post(req, headers=headers)
                if loyalty_answ.status_code == 200:
                    break
                else:
                    if retries_left > 0:
                        logging.info('Loyalty answer status code is %d, retrying...', loyalty_answ.status_code)
                        time.sleep(10)
                    else:
                        raise Exception()

            coins.append(loyalty_answ.json()['id'])
        except Exception as exc:
            logging.exception(
                'Exception trying to create coins: %s. Url %s', exc, req)
            raise exc

    return coins


def cart(options, count):
    cart_count = int(0.4 * count) + 1
    result = []
    coins_enabled = options.get('coins_disabled') != True
    for i in xrange(cart_count):
        result.append(cart_internal(options, random.choice(options['existing_users']), None, None))

    if coins_enabled == True:
        cart_coupon_count = int(0.1 * count) + 1
        for i in xrange(cart_coupon_count):
            result.append(cart_internal(options, random.choice(options['existing_users']), None,
                                    random.choice(options['available_promocodes'])))

        cart_coins_count = int(0.3 * count) + 1
        for i in xrange(cart_coins_count):
            uid = random.choice(options['existing_users'])
            result.append(cart_internal(options, uid, make_coins(options, uid, random.randint(1, 3)), None))

        cart_coins_coupon_count = int(0.2 * count) + 1
        for i in xrange(cart_coins_coupon_count):
            uid = random.choice(options['existing_users'])
            result.append(cart_internal(options, uid, make_coins(options, uid, random.randint(1, 3)),
                                    random.choice(options['available_promocodes'])))
    return result


def cart_internal(options, uid, coins, promo):
    promo_code_line = '"promocode": "' + promo + '",' if promo is not None else ''
    coins_line = '"coinIdsToUse": [' + ','.join(map(str, coins)) + '],' if coins is not None else ''
    tag = "POST_cart"
    if coins is not None:
        tag = tag + '_coins'
    if promo is not None:
        tag = tag + '_coupon'

    payload = u'''{
    "buyerRegionId": %d,
    %s
    "buyerCurrency": "RUR",
    "carts": [
        {
            "shopId": %s,
            %s
            "items": [
                {
                    "feedId": %s,
                    "offerId": "%s",
                    "showInfo": "%s",
                    "count": 1
                }
            ],
            "delivery" : {
                "regionId" : %d,
                "address" : {
                    "country" : "Россия",
                    "postcode" : "119313",
                    "city" : "Санкт-Петербург",
                    "subway" : "Проспект Вернадского",
                    "street" : "Ленинский проспект",
                    "house" : "90",
                    "floor" : "6"
                }
            }
        }
    ]
}''' % (
        213, promo_code_line, options['shop_id'], coins_line, options['feed_id'], options['offer_id'],
        options['fee_show'],
        213)

    return make_ammo('POST', '/cart?rgb=BLUE&minifyOutlets=true&uid={}'.format(uid),
                     tag, body=payload)


def multicart_actualize(options, count):
    coins_enabled = options.get('coins_disabled') != True
    cart_count = int(0.4 * count) + 1
    result = []
    for i in xrange(cart_count):
        uid = random.choice(options['existing_users'])
        result.append(multicart_actualize_internal(options, uid, None))

    if coins_enabled == True:
        cart_coins_count = int(0.3 * count) + 1
        for i in xrange(cart_coins_count):
            uid = random.choice(options['existing_users'])
            coins = make_coins(options, uid, random.randint(1, 3))
        result.append(multicart_actualize_internal(options, uid, coins))

    return result


def multicart_actualize_internal(options, uid, coins):
    coins_line = '"coinIdsToUse": [' + ','.join(map(str, coins)) + '],' if coins is not None else ''
    tag = "POST_multicart_actualize"
    if coins is not None:
        tag = tag + '_coins'
    payload = u'''{
    "buyer": {
        "userId": %d,
        "regionId": %d,
        "currency": "RUR"
    },
    %s
    "carts": [{
        "label": "cart-1",
        "shopId": %s,
        "items": [{
            "label": "item-1",
            "feedId": %s,
            "offerId": "%s",
            "buyerPrice": "%s",
            "count": 1
        }]
    }]
    }
    ''' % (
        uid,
        213,
        coins_line,
        options['shop_id'],
        options['feed_id'],
        options['offer_id'],
        options['offer_price']
    )
    return make_ammo('POST', '/v2/multicart/actualize?rgb=BLUE', tag, body=payload)


def checkout(options, count):
    checkout_coupon_count = int(0.1 * count) + 1
    result = []
    for i in xrange(checkout_coupon_count):
        result.append(checkout_internal(options, random.choice(options['existing_users']), None,
                                        random.choice(options['available_promocodes'])))

    checkout_coins_count = int(0.3 * count) + 1
    for i in xrange(checkout_coins_count):
        uid = random.choice(options['existing_users'])
        result.append(checkout_internal(options, uid, make_coins(options, uid, random.randint(1, 3)), None))

    checkout_coins_coupon_count = int(0.2 * count) + 1
    for i in xrange(checkout_coins_coupon_count):
        uid = random.choice(options['existing_users'])
        result.append(checkout_internal(options, uid, make_coins(options, uid, random.randint(1, 3)),
                                        random.choice(options['available_promocodes'])))

    checkout_count = int(0.4 * count) + 1
    for i in xrange(checkout_count):
        result.append(checkout_internal(options, random.choice(options['existing_users']), None, None))
    return result


def checkout_internal(options, uid, coins, promo):
    promo_code_line = '"promocode": "' + promo + '",' if promo is not None else ''
    coins_line = '"coinIdsToUse": [' + ','.join(map(str, coins)) + '],' if coins is not None else ''

    tag = "POST_checkout"
    if coins is not None:
        tag = tag + '_coins'
    if promo is not None:
        tag = tag + '_coupon'

    payload = u'''
    {
        "buyerRegionId": %s,
        "buyerCurrency": "RUR",
        "paymentType": "POSTPAID",
        %s
        "paymentMethod": "CASH_ON_DELIVERY",
        "orders": [
            {
                "shopId": %s,
                %s
                "items": [
                    {
                        "feedId": %s,
                        "offerId": "%s",
                        "showInfo": "%s",
                        "buyerPrice": %s,
                        "count": 1
                    }
                ],
                "delivery": {
                    "id": "%s",
                    "regionId": %s,
                    %s
                },
                "notes": "заметочка"
            }
        ],
        "buyer": {
            "lastName": "последнееимя",
            "firstName": "первоеимя",
            "middleName": "среднееимя",
            "phone": "%s",
            "email": "%s",
            "ip": "8.8.8.8"
        }
    }
    ''' % (
        '213',
        promo_code_line,
        options['shop_id'],
        coins_line,
        options['feed_id'],
        options['offer_id'],
        options['fee_show'],
        options['offer_price'],
        options['delivery_id'],
        '213',
        options['outlet'],
        random_phone(),
        random_email()
    )

    return make_ammo('POST', '/checkout?rgb=BLUE&uid={}&minifyOutlets=true'.format(uid), tag, body=payload)


def notify_tracks(options, count):
    result = []
    for i in xrange(count):
        result.append(notify_tracks_internal(options))
    return result


def notify_tracks_internal(options):
    order_id = random.choice(options['available_orders'])
    track_id = random.choice(options['available_track_ids'])
    track_code = random.choice(options['available_track_codes'])

    payload = u'''
    [
        {
            "deliveryTrackMeta": {
            "id": %s,
            "trackCode": "%s",
            "backUrl": "http://checkouter.market.http.yandex.net:39001/notify-tracks",
            "deliveryServiceId": 107,
            "consumerId": 1,
            "sourceId": 0,
            "startDate": 1570705041617,
            "lastUpdatedDate": 1570739257988,
            "lastNotifySuccessDate": 1570738057475,
            "nextRequestDate": 1570741957988,
            "orderId": "%s",
            "deliveryTrackStatus": "STARTED",
            "estimatedArrivalDate": {
            "from": [
                2019,
                10,
                11
            ],
            "to": [
                2019,
                10,
                11
            ]
        },
        "deliveryType": "PICKUP",
        "lastCheckpointAcquiredDate": 1570741370707,
        "stopTrackingDate": 1575925370723,
        "lastOrdersStatusRequestDate": 1570741345191,
        "globalOrder": false
        },
        "deliveryTrackCheckpoints": [
        {
            "id": %s,
            "trackId": %s,
            "message": "заказ поступил в филиал СД",
            "checkpointStatus": "IN_TRANSIT",
            "checkpointDate": 1570741342000,
            "deliveryCheckpointStatus": 40,
            "surveyType": "PUSH"
        },
        {
            "id": %s,
            "trackId": %s,
            "message": "заказ поступил на склад СД",
            "checkpointStatus": "IN_TRANSIT",
            "checkpointDate": 1570741342000,
            "deliveryCheckpointStatus": 10,
            "surveyType": "PUSH"
        },
        {
            "id": %s,
            "trackId": %s,
            "message": "заказ создан в информационной системе СД корректно",
            "checkpointStatus": "INFO_RECEIVED",
            "checkpointDate": 1570704902000,
            "deliveryCheckpointStatus": 1,
            "lastNotifySuccessDate": 1570706388707,
            "surveyType": "PUSH"
        }
        ]
    }
    ]''' % (
        track_id,
        order_id,
        track_code,
        random.choice(options['available_checkpoint_ids']),
        track_id,
        random.choice(options['available_checkpoint_ids']),
        track_id,
        random.choice(options['available_checkpoint_ids']),
        track_id,
    )

    return make_ammo('POST', '/notify-tracks', 'POST_notify_tracks', body=payload)


def actualize(options, count):
    result = []
    for i in xrange(count):
        payload = u'''{
            "buyerRegionId": 213,
            "shopId": %s,
            "feedId": %s,
            "offerId": "%s"
        }''' % (options['shop_id'], options['feed_id'], options['offer_id'])

        result.append(make_ammo('POST',
                                '/actualize?rgb=BLUE&minifyOutlets=true&uid={}'.format(
                                    random.choice(options['existing_users'])),
                                'POST_actualize', body=payload))
    return result


def categorize(options, count):
    result = []
    for i in xrange(count):
        payload = u'''{
            "wareMd5Ids": ["%s"],
            "rid": 213
        }''' % (options['ware_id'])

        result.append(make_ammo('POST',
                                '/offers/categorize?rgb=BLUE',
                                'POST_categorize', body=payload))
    return result


def auth(options, count):
    result = []
    for i in xrange(count):
        payload = u'''{
            "ip": "192.168.1.1",
            "userAgent": "user-agent"
        }'''

        result.append(make_ammo('POST',
                                '/auth?skipMuidGenerationLimit=true',
                                'POST_auth', body=payload))
    return result


def order_events(options, count, archived='false'):
    result = []
    for i in xrange(count):
        last_event_id = random.choice(options['last_event_id_range'])
        result.append(make_ammo("GET",
                                "/orders/events?lastEventId={}&batchSize=50&rgb=WHITE&rgb=BLUE&archived={}"
                                .format(last_event_id, archived),
                                "GET_orders_events_archived_" + archived))
    return result


def order_events_by_order_id(options, count, archived='false'):
    result = []
    if archived == 'true':
        order_ids = options['archived_available_orders']
    else:
        order_ids = options['latest_orders']
    for i in xrange(count):
        order_id = random.choice(order_ids)
        result.append(make_ammo("GET",
                                "/orders/events/by-order-id?orderId={}&archived={}&rgb=BLUE".format(order_id,
                                                                                                    archived) +
                                "&eventType=NEW_ORDER&eventType=ORDER_STATUS_UPDATED",
                                "GET_orders_events_by-order-id_archived_" + archived))
    return result


def orders_by_id(options, count, archived='false'):
    result = []
    if archived == 'true':
        available_orders = options['archived_available_orders']
    else:
        available_orders = options['available_orders']

    for i in xrange(count):
        order_id = random.choice(available_orders)
        result.append(make_ammo("GET",
                                "/orders/{}?clientRole=SYSTEM&archvied={}&rgb=BLUE".format(order_id, archived),
                                "GET_orders_orderId_archived_" + archived))
    return result


def orders_by_id_receipts(options, count, archived='false'):
    result = []
    if archived == 'true':
        available_orders = options['archived_available_orders']
    else:
        available_orders = options['available_orders']

    for i in xrange(count):
        order_id = random.choice(available_orders)
        result.append(
            make_ammo("GET",
                      "/orders/{}/receipts?clientRole=SYSTEM&archived={}&rgb=BLUE".format(order_id, archived),
                      "GET_orders_orderId_receipts_archived_" + archived))
    return result


def orders_status(options, count):
    result = []
    for i in xrange(count):
        order_id = random.choice(options['processing_orders'])
        result.append(
            make_ammo("POST", "/orders/{}/status?clientRole=SYSTEM&status=DELIVERY".format(order_id),
                      "POST_orders_orderId_status"))
    return result


def orders_orderid_events(options, count, archived='false'):
    result = []
    if archived == 'true':
        available_orders = options['archived_available_orders']
    else:
        available_orders = options['available_orders']

    for i in xrange(count):
        result.append(
            make_ammo("GET",
                      "/orders/{}/events?format=json&clientRole=SYSTEM&pageSize=30&archived={}&rgb=BLUE"
                      .format(random.choice(available_orders), archived),
                      "GET_orders_orderId_events_archived_" + archived))
    return result


def orders_options_availabilities(options, count):
    result = []
    for i in xrange(count):
        order_id = random.choice(options['available_orders'])
        result.append(
            make_ammo("GET", "/orders/options-availabilities?clientRole=SYSTEM&orderId={}&rgb=BLUE"
                      .format(order_id), "GET_orders_options-availabilities"))
    return result


def orders_orderid_receipts_receiptid_pdf(options, count, archived='false'):
    result = []
    if archived == 'true':
        order_ids_receipt_ids = options['archived_order_ids_receipt_ids']
    else:
        order_ids_receipt_ids = options['order_ids_receipt_ids']

    for i in xrange(count):
        order_id_receipt_id = random.choice(order_ids_receipt_ids)
        result.append(
            make_ammo("GET",
                      "/orders/{}/receipts/{}/pdf?clientRole=SYSTEM&rgb=BLUE&archived={}"
                      .format(order_id_receipt_id[0], order_id_receipt_id[1], archived),
                      "GET_orders_orderId_receipts_receiptId_pdf_archived_" + archived))
    return result


def orders_orderid_warranty(options, count, archived='false'):
    result = []
    if archived == 'true':
        available_orders = options['archived_available_orders']
    else:
        available_orders = options['available_orders']

    for i in xrange(count):
        result.append(
            make_ammo("GET",
                      "/orders/{}/warranty?clientRole=SYSTEM&archived={}&rgb=BLUE"
                      .format(random.choice(available_orders), archived),
                      "GET_orders_orderId_warranty_archived_" + archived))
    return result


def payments_paymentid(options, count, archived='false'):
    result = []
    if archived == 'true':
        payment_ids = options['archived_payment_ids']
    else:
        payment_ids = options['payment_ids']

    for i in xrange(count):
        result.append(
            make_ammo("GET",
                      "/payments/{}?clientRole=SYSTEM&rgb=BLUE&archived={}"
                      .format(random.choice(payment_ids), archived),
                      "GET_payments_paymentId_archived_" + archived))
    return result


def orders_orderid_payments(options, count, archived='false'):
    result = []
    if archived == 'true':
        order_ids_with_payment = options['archived_order_ids_with_payment']
    else:
        order_ids_with_payment = options['order_ids_with_payment']

    for i in xrange(count):
        order_id = random.choice(order_ids_with_payment)
        result.append(
            make_ammo("GET",
                      "/orders/{}/payments?clientRole=SYSTEM&archived={}&rgb=BLUE".format(order_id, archived),
                      "GET_orders_orderId_payments_archived_" + archived))
    return result


def pushapi_settings_shopid(options, count):
    result = []
    for i in xrange(count):
        shop_id = options['shop_id']
        result.append(
            make_ammo("GET", "/pushapi-settings/{}?clientRole=SYSTEM"
                      .format(shop_id), "GET_pushapi-settings_shopId"))
    return result


def shops_datasourceid(options, count):
    result = []
    for i in xrange(count):
        shop_id = options['shop_id']
        result.append(
            make_ammo("GET", "/shops/{}?clientRole=SYSTEM"
                      .format(shop_id), "GET_shops_datasourceId"))
    return result


def random_email():
    return ''.join(random.sample(string.lowercase, 10)) + '@' + ''.join(random.sample(string.lowercase, 10)) + '.ru'


def random_phone():
    return "+7" + ''.join(random.sample('0123456789', 10))


cart.is_archive_api = False
multicart_actualize.is_archive_api = False
actualize.is_archive_api = False
categorize.is_archive_api = False
auth.is_archive_api = False
checkout.is_archive_api = False
notify_tracks.is_archive_api = False
orders_status.is_archive_api = False
pushapi_settings_shopid.is_archive_api = False
get_orders_user.is_archive_api = True
orders_by_uid_recent.is_archive_api = False
orders_by_uid_recent_sort_by_importance.is_archive_api = False
orders_options_availabilities.is_archive_api = False
shops_datasourceid.is_archive_api = False
orders_orderid_receipts_receiptid_pdf.is_archive_api = True
orders_orderid_warranty.is_archive_api = True
payments_paymentid.is_archive_api = True
orders_orderid_payments.is_archive_api = True
orders_by_id_receipts.is_archive_api = True
order_events_by_order_id.is_archive_api = True
orders_orderid_events.is_archive_api = True
order_events.is_archive_api = True
orders_by_id.is_archive_api = True
orders_by_uid.is_archive_api = True
orders_by_uid_sort_by_importance.is_archive_api = True
