from sandbox import sdk2
from sandbox.sdk2 import yav
from notificator import Notificator
import sandbox.projects.common.environments as env


class MarketSupportDutyNotificator(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [env.PipEnvironment("python-dateutil")]

    class Parameters(sdk2.Task.Parameters):
        calendar_id = sdk2.parameters.Integer('Support duty calendar ID:', default=30271)
        notification_chat_id = sdk2.parameters.Integer('Chat id for notifications:')
        enable_unpin = sdk2.parameters.Bool('Enable unpinning', default='false')
        enable_pin = sdk2.parameters.Bool('Enable pinning', default='false')
        hotline_chat_url = sdk2.parameters.String('Hotline chat link', default='https://t.me/+mXHGMDZwSbg1MDMy')
        support_chat_url = sdk2.parameters.String('Link to this chat: ', default='https://t.me/joinchat/QCdvpK1NUZKi6NBM')

    def on_execute(self):
        yav_tokens = yav.Secret('sec-01dz6ebf34gs5sj9g47asjrmc5')
        notificator = Notificator(
            yav_tokens,
            self.Parameters.calendar_id,
            self.Parameters.notification_chat_id,
            self.Parameters.enable_pin,
            self.Parameters.enable_unpin,
            self.Parameters.hotline_chat_url,
            self.Parameters.support_chat_url
        )
        notificator.do_notification()
