from sandbox import sdk2
from sandbox.projects.common import binary_task

from sandbox.projects.market.checkout.MarketLoadTestResultProcessor.shootings_processor import ShootingsProcessor


class MarketLoadTestResultProcessor(binary_task.LastBinaryTaskRelease, sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        ext_params = binary_task.binary_release_parameters(stable=True)

    def on_execute(self):
        binary_task.LastBinaryTaskRelease.on_execute(self)
        solomon_token = sdk2.Vault.data('MARKET', 'market_checkouter_solomon_oauth_token')
        stat_token = sdk2.Vault.data('MARKET', 'stat_oauth_token')
        ShootingsProcessor(solomon_token, stat_token).process()
