USE marketclickhouse;

SELECT page_id,
       count() / (16 * 60 * 60) rps
FROM market.market_loyalty
WHERE date = today() - 1
  AND toHour(toDateTime(timestamp)) BETWEEN 8 AND 23
  AND page_id not in ('ping_using_get', 'get_sensors_using_get', 'get_sensors_using_get_1') --('/ping', '/solomon', '/solomon-jvm')
  AND "type" = 'IN'
  AND environment = 'PRODUCTION'
GROUP BY page_id
HAVING rps > 1 or page_id in (
    'pumpkin_status_using_get',
    'price_left_for_free_delivery_v2_using_post',
    'find_promos_by_uid_and_promo_group_token_using_post',
    'get_coin_promo_info_using_get'
)
ORDER BY rps DESC;
